package cn.freemud.service.impl;

import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.entities.dto.ActivityCalculationDiscountRequestDto;
import cn.freemud.entities.dto.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ActivityChannelEnum;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.CommonService;
import cn.freemud.service.thirdparty.ActivityClient;
import cn.freemud.utils.PropertyConvertUtil;
import com.freemud.application.sdk.api.log.ErrorLog;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CalculationServiceImpl
 * @Package cn.freemud.service.impl
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/6/11 17:06
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class CalculationServiceImpl {


    @Autowired
    private CommonService commonService;
    @Autowired
    private ActivityClient activityClient;

    /**
     * 更新购物车行优惠信息
     */
    public void updateShoppingCartGoodsDiscount(
            String partnerId, String storeId, String userId, String appId, Integer orderType, boolean isMember,String menuType, Long deliveryAmount,
            ShoppingCartInfoRequestVo requestVo, ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo, CustomerInfoVo customerInfoVo,
            List<CartGoods> cartGoodsList,

            CouponPromotionVO couponPromotionVO, ActivityQueryDto activityQueryDto,
            UserLoginInfoDto userLoginInfoDto
            ) {
//        ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscount = getCalculationDiscount(requestVo, customerInfoVo, cartGoodsList, deliveryAmout);
//        defaultDiscountStrategy.updateShoppingCartGoodsDiscount(shoppingCartGoodsResponseVo, cartGoodsList, calculationDiscount);
//        fullSubDiscountStrategy.updateShoppingCartGoodsDiscount(requestVo,shoppingCartGoodsResponseVo, cartGoodsList,customerInfoVo, calculationDiscount);
//        customerScoreService.updateShoppingCartGoodsDiscount(null, null, calculationDiscount, cartGoodsList, shoppingCartGoodsResponseVo, BeanUtil.convertBean(customerInfoVo, UserLoginInfoDto::new), requestVo);
//        setMealDiscountStrategy.updateShoppingCartGoodsDiscount(shoppingCartGoodsResponseVo, cartGoodsList, calculationDiscount);
    }



    public ActivityCalculationDiscountResponseDto.CalculationDiscountResult getCalculationDiscount(
            String partnerId, String storeId, String userId, String appId, Integer orderType, boolean isMember, List<CartGoods> cartGoodsList,
            List<ActivityCalculationDiscountRequestDto.CalculationDiscountCoupon> coupons,
            List<ShoppingCartInfoRequestVo.SendGoods> sendGoodsList, String menuType, Long deliveryAmount) {

        List<ActivityCalculationDiscountRequestDto.CalculationDiscountGoods> calculationDiscountGoodsList = new ArrayList<>();
        for (CartGoods cartGoods : cartGoodsList){
            addCalculationDiscountGoods(calculationDiscountGoodsList, cartGoods.getGoodsId(), cartGoods.getQty(), cartGoods.getFinalPrice(), cartGoods.getMemberDiscount());
        }

        ActivityCalculationDiscountRequestDto discountRequest = getActivityCalculationDiscountRequestDto(partnerId, storeId, userId, appId, orderType);
        discountRequest.setGoods(calculationDiscountGoodsList);
        discountRequest.setCoupons(coupons);
        discountRequest.setOrgIds(commonService.getOrgIds(partnerId, storeId));
        discountRequest.setDistributionFee(deliveryAmount);
        discountRequest.setIsMember(isMember);
        try {
            ActivityCalculationDiscountResponseDto activityCalculationDiscountResponseDto = activityClient.calculationDiscountSharing(discountRequest);
            // 返回成功
            if (activityCalculationDiscountResponseDto != null && StringUtils.equals(activityCalculationDiscountResponseDto.getStatusCode(), ResponseCodeConstant.RESPONSE_SUCCESS_STR)) {
                ActivityCalculationDiscountResponseDto.CalculationDiscountResult result = activityCalculationDiscountResponseDto.getResult();
                result.setDeliveryAmount(deliveryAmount);
                result.setDistributionFee(result.getDistributionFee());
                return result;
            }
        } catch (Exception ex) {
            ErrorLog.printErrorLog("calculation_discount_error", "/calculation/discount/sharding", discountRequest, ex);
            throw new ServiceException(ResponseResult.OPERATE_TOO_OFTEN);
        }
        throw new ServiceException(ResponseResult.OPERATE_TOO_OFTEN);
    }


    /**
     * 构建 ActivityCalculationDiscountRequestDto
     *
     * @param partnerId
     * @param storeId
     * @param userId
     * @param appId
     * @param orderType
     * @return
     */
    private ActivityCalculationDiscountRequestDto getActivityCalculationDiscountRequestDto(String partnerId, String storeId, String userId, String appId, Integer orderType) {
        ActivityCalculationDiscountRequestDto activityCalculationDiscountRequestDto = new ActivityCalculationDiscountRequestDto();
        activityCalculationDiscountRequestDto.setPartnerCode(partnerId);
        activityCalculationDiscountRequestDto.setStoreId(storeId);
        activityCalculationDiscountRequestDto.setIsShowGoodsActivity(1);
        activityCalculationDiscountRequestDto.setUserId(userId);
        activityCalculationDiscountRequestDto.setVer(1);
        activityCalculationDiscountRequestDto.setAppId(appId);
        ActivityChannelEnum activityChannelEnum = PropertyConvertUtil.orderTypeConvert2ActivityChannel(orderType);
        if (!Objects.isNull(activityChannelEnum)) {
            activityCalculationDiscountRequestDto.setChannel(activityChannelEnum.getCode());
        }
        return activityCalculationDiscountRequestDto;
    }

    /**
     * 将calculationDiscountGoods 封装后加入 calculationDiscountGoodsList
     *
     * @param calculationDiscountGoodsList
     * @param goodsId
     * @param goodsQuantity
     * @param originalPrice
     */
    private void addCalculationDiscountGoods(List<ActivityCalculationDiscountRequestDto.CalculationDiscountGoods> calculationDiscountGoodsList,
                                             String goodsId, Integer goodsQuantity, Long originalPrice, Integer memberDiscount) {
        ActivityCalculationDiscountRequestDto.CalculationDiscountGoods calculationDiscountGoods = new ActivityCalculationDiscountRequestDto.CalculationDiscountGoods();
        calculationDiscountGoods.setGoodsId(goodsId);
        calculationDiscountGoods.setGoodsQuantity(goodsQuantity);
        calculationDiscountGoods.setOriginalPrice(originalPrice);
        calculationDiscountGoods.setMemberDiscount(memberDiscount);

        //累加需加入计算的商品
        int index;
        // 当商品已存在时,需累加数量
        if ((index = calculationDiscountGoodsList.indexOf(calculationDiscountGoods)) >= 0) {
            ActivityCalculationDiscountRequestDto.CalculationDiscountGoods oldCalculationDiscountGoods = calculationDiscountGoodsList.get(index);
            oldCalculationDiscountGoods.setGoodsQuantity(oldCalculationDiscountGoods.getGoodsQuantity() + calculationDiscountGoods.getGoodsQuantity());
        } else {
            calculationDiscountGoodsList.add(calculationDiscountGoods);
        }
    }


}
