package cn.freemud.management.entities.dto.request.console;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/12/24 上午9:47
 * @description : 派单配置
 */
@Data
public class DispatchConfig {

    /**
     * 0工作日
     */
    public static int DATETYPE_ZERO = 0;

    /**
     * 1双休日
     */
    public static int DATETYPE_ONE = 1;

    /**
     * 2活动日
     */
    public static int DATETYPE_TWO = 2;


    /**
     * 日期类型（0工作日，1双休日，2活动日）
     */
    private int dateType;

    /**
     * 派单时间（分钟）
     */
    private Integer dispatchTime;

    /**
     * 2活动日 才有值
     * 活动开始时间(yyyy-MM-dd HH:mm:ss)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;
    /**
     * 2活动日 才有值
     * 活动结束时间(yyyy-MM-dd HH:mm:ss)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 高峰期派单配置（json）
     */
    private List<PeakTimeConfig> peakTimeConfigList;
}
