package com.freemud.sdk.api.assortment.order.adapter;


import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.membercenter.response.GetMemberExtendInfoResponse;
import com.freemud.application.sdk.api.ordercenter.entities.v1.AccountBeanV1;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.entities.v1.ProductBeanV1;
import com.freemud.application.sdk.api.ordercenter.entities.v1.ProductDiscountV1;
import com.freemud.application.sdk.api.ordercenter.enums.orderv1.OrderAccountTypeV1;
import com.freemud.application.sdk.api.promotioncenter.request.promotion.CalculationDiscountRequest;
import com.freemud.sdk.api.assortment.order.request.order.ActivityCancelStockRequest;
import com.freemud.sdk.api.assortment.order.request.order.CouponCodeVerificationProductRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Component
public class ActivitySdkAdapter {

    /**
     * 扣减库存数量
     */
    private static final int STACK_SUB = 1;

    public ActivityCancelStockRequest convert2ActivityCancelStockRequestDto(OrderBeanV1 orderBean, List<Integer> transType) {


        ActivityCancelStockRequest activityCancelStockRequest = new ActivityCancelStockRequest();
        activityCancelStockRequest.setVer("1");
        activityCancelStockRequest.setPartnerCode(orderBean.getCompanyId());
        activityCancelStockRequest.setStoreId(orderBean.getShopId());
        activityCancelStockRequest.setOrderId(orderBean.getOid());
        activityCancelStockRequest.setTransType(transType);
        activityCancelStockRequest.setUserId(orderBean.getUserId());
        List<ActivityCancelStockRequest.ProductVo> orderProducts = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(orderBean.getProductList())) {
            orderBean.getProductList().forEach(productBean -> {
                ActivityCancelStockRequest.ProductVo productStock = new ActivityCancelStockRequest.ProductVo();
                productStock.setSkuId(productBean.getSpecification());
                productStock.setQty(productBean.getNumber());
                orderProducts.add(productStock);
            });
        }
        activityCancelStockRequest.setProducts(orderProducts);
        //优惠券冲正
        List<AccountBeanV1> accountList = orderBean.getAccountList();
        if (!CollectionUtils.isEmpty(accountList) && !CollectionUtils.isEmpty(orderBean.getProductList())) {
            for (AccountBeanV1 accountBean : accountList) {
                List<CouponCodeVerificationProductRequest> products = new ArrayList<>();
                //订单中存储的6代表商品券
                if (Objects.equals(accountBean.getType(), OrderAccountTypeV1.PRODUCT_COUPON.getV1code())) {
                    for (int i = 0; i < orderBean.getProductList().size(); i++) {
                        ProductBeanV1 productBean = orderBean.getProductList().get(i);
                        String pid = StringUtils.isNotBlank(productBean.getSpecification()) ? productBean.getSpecification() : productBean.getProductId();
                        if (!org.springframework.util.CollectionUtils.isEmpty(orderBean.getProductList().get(i).getDiscountList())) {
                            List<ProductDiscountV1> discounts = orderBean.getProductList().get(i).getDiscountList().stream().
                                    filter(productDiscount -> productDiscount.getDiscountId().equals(accountBean.getAccountId())).collect(Collectors.toList());
                            for (ProductDiscountV1 productDiscount : discounts) {
                                CouponCodeVerificationProductRequest couponCodeVerificationProductDto = new CouponCodeVerificationProductRequest();
                                couponCodeVerificationProductDto.setPID(pid);
                                couponCodeVerificationProductDto.setConsume_num(productDiscount.getDiscountQty());
                                couponCodeVerificationProductDto.setSeq(i + 1);
                                products.add(couponCodeVerificationProductDto);
                            }
                        }
                    }
                }
                if (OrderAccountTypeV1.COUPON.getV1code().equals(accountBean.getType())
                        || OrderAccountTypeV1.PRODUCT_COUPON.getV1code().equals(accountBean.getType())
                        || OrderAccountTypeV1.DISCOUNT_COUPON.getV1code().equals(accountBean.getType())) {
                    activityCancelStockRequest.setCouponCode(accountBean.getAccountId());
                    activityCancelStockRequest.setCouponProducts(products);
                }
            }
        }

        return activityCancelStockRequest;
    }

    public CalculationDiscountRequest convert2CalculationDiscountRequestDto(OrderBeanV1 orderBean,
                                                                            GetMemberExtendInfoResponse extendInfoResponse){
        JSONObject jsonObject=JSONObject.parseObject(orderBean.getExtInfo());
        CalculationDiscountRequest discountRequest=new CalculationDiscountRequest();
        discountRequest.setPartnerCode(orderBean.getCompanyId());
        discountRequest.setStoreId(orderBean.getShopId());
        discountRequest.setAppId(jsonObject.getString("appid"));
        discountRequest.setUserId(orderBean.getUserId());
        discountRequest.setApplication("isaas");
        discountRequest.setChannel("pickup");
        discountRequest.setVer(1);
        discountRequest.setGoods(new ArrayList<CalculationDiscountRequest.CalculationDiscountGoods>());
//        if(CollectionUtils.isNotEmpty(extendInfoResponse.getMemberPaids()))
//            discountRequest.setMemberLevel(extendInfoResponse.getMemberPaids().get(0).getPaidId());
//        else
//            discountRequest.setMemberLevel("-1");

        if(CollectionUtils.isNotEmpty(extendInfoResponse.getMemberLabels())) {
            discountRequest.setCustomerLabel(extendInfoResponse.getMemberLabels().stream().map(GetMemberExtendInfoResponse.GetMemberLabels::getLabelCode).collect(Collectors.joining(",")));
        }else
            discountRequest.setCustomerLabel("-1");
        //推送优惠的时候 把商品价格置为0 额外新增一条虚拟商品金额设为订单实付金额
        if(CollectionUtils.isNotEmpty(orderBean.getProductList())){
            orderBean.getProductList().forEach(productBean -> {
                CalculationDiscountRequest.CalculationDiscountGoods discountGoods=new CalculationDiscountRequest.CalculationDiscountGoods();
                discountGoods.setCategory(" ");
                discountGoods.setGoodsId(productBean.getSpecification());
                discountGoods.setGoodsQuantity(productBean.getNumber());
                discountGoods.setOriginalPrice(0l);
                discountRequest.getGoods().add(discountGoods);
            });
            CalculationDiscountRequest.CalculationDiscountGoods discountGoods=new CalculationDiscountRequest.CalculationDiscountGoods();
            discountGoods.setGoodsId("1234");
            discountGoods.setGoodsQuantity(1);
            discountGoods.setOriginalPrice(orderBean.getAmount());
            discountRequest.getGoods().add(discountGoods);
        }
        CalculationDiscountRequest.CalculationDiscountCoupon discountCoupon=new CalculationDiscountRequest.CalculationDiscountCoupon();
        return discountRequest;
    }
}
