/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: PromotionActivityClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/6 11:14
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.annotations.LogIgnoreFeign;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.ActivityQueryRequestDto;
import cn.freemud.entities.dto.activity.ActivityQueryResponseDto;
import cn.freemud.entities.dto.promotion.*;
import cn.freemud.entities.vo.QueryGroupHistoryRequest;
import cn.freemud.entities.vo.QuerySpellGroupRequest;
import com.freemud.application.sdk.api.promotioncenter.response.PromotionResponseDTO;
import com.freemud.sdk.api.assortment.order.entities.promption.ActivityUpdateStockRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "promotion-service", url = "${saas.activityclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface PromotionDiscountClient {


    /**
     * 新版优惠均摊计算
     * @param calculationDiscountRequestDto
     * @return
     */
    @LogIgnoreFeign(logMessage="calculationDiscountSharing",messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping("/calculation/discount/sharing")
    ActivityCalculationDiscountResponseDto calculationDiscountSharing(CalculationDiscountRequestDto calculationDiscountRequestDto);

    /**
     * 统一活动查询接口
     */
    @LogIgnoreFeign(logMessage="activityQuery",messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping("/activity/query")
    ActivityQueryResponseDto query(ActivityQueryRequestDto activityQueryRequestDto);

    /**
     * 优惠金额计算
     */
    @LogIgnoreFeign(logMessage="calculationDiscount",messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping("/calculation/discount")
    CalculationDiscountResponseDto calculationDiscount(CalculationDiscountRequestDto calculationDiscountRequestDto);


    /**
     * 查询团信息
     * @param groupWorkQueryRequest
     * @return
     */
    @LogIgnoreFeign(logMessage="groupWorkQuery",messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping("/groupWork/query")
    GroupWorkQueryResponse groupWorkQuery(GroupWorkQueryRequest groupWorkQueryRequest);


    /**
     * 支付回调时，参团
     * @param groupWorkJoinRequest
     * @return
     */
    @LogIgnoreFeign(logMessage="groupWorkJoin",messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping("/activity/groupWork/join")
    GroupWorkJoinResponse groupWorkJoin(GroupWorkJoinRequest groupWorkJoinRequest);

    /**
     * 通过团号查询团信息
     * @param querySpellGroupRequest
     * @return
     */
    @LogIgnoreFeign(logMessage="queryByGroupId",messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping("/activity/groupWork/queryByGroupId")
    QuerySpellGroupVoResponse queryByGroupId(QuerySpellGroupRequest querySpellGroupRequest);

    /**
     * 通过团号查询团信息
     * @param querySpellGroupRequest
     * @return
     */
    @LogIgnoreFeign(logMessage="queryHistory",messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping("/activity/groupWork/queryHistory")
    QueryHistoryGroupVOResponse queryHistory(QueryGroupHistoryRequest querySpellGroupRequest);

    /**
     * 扣减活动库存
     */
    @PostMapping("/activity/stock/subtractStock")
    PromotionResponseDTO subtractStock(@RequestBody ActivityUpdateStockRequest activityReq);
}
