package cn.freemud.service.impl.calculate.promotion;

import cn.freemud.constant.ShoppingCartConstant;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.entities.vo.ShoppingCartGoodsResponseVo;
import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.impl.AssortmentSdkService;
import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.ShoppingCartBaseServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: cn.freemud.service.impl.calculate.promotion AdditionSharingService
 * @Description: 加价购商品
 * @author: family
 * @date: 2020/9/14
 * @Copyright: www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class AdditionSharingService {

    @Autowired
    private AssortmentSdkService assortmentSdkService;

    @Autowired
    private ShoppingCartBaseServiceImpl shoppingCartBaseService;

    public void additionResponse(CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult
            , List<CartGoods> cartGoodsList
            , ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo
            , ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {

        if (shoppingCartInfoRequestVo==null
                || CollectionUtils.isEmpty(shoppingCartInfoRequestVo.getSendGoods())
                || discountResult==null
                || CollectionUtils.isEmpty(discountResult.getSendGoods())) {
            return;
        }

        //检查是否有加价购商品
        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.SendActivity> sendGoods = discountResult.getSendGoods()
                .stream()
                .filter(s -> ActivityTypeEnum.TYPE_81.getCode().equals(s.getActivityType()))
                .collect(Collectors.toList());

        if (CollectionUtils.isEmpty(sendGoods)) {
            return;
        }
        List<CreateOrderVo.PremiumExchangeActivity.Product> additionalProducts = this.buildPremiumExchangeActivityProduct(shoppingCartInfoRequestVo);
        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.SendActivity> additionalActivityList = discountResult.getSendGoods();
        ResponseResult checkResult = checkAdditionalGoods(additionalProducts, additionalActivityList);
        if (!ObjectUtils.equals(ResponseResult.SUCCESS, checkResult)) {
            throw new ServiceException(checkResult);
        }


        Long totalDiscountPrice = 0L;
        Long totalNowPrice = 0L;
        // goodsId->qty
        Map<String, Integer> map = shoppingCartInfoRequestVo.getSendGoods()
                .stream()
                .collect(Collectors.toMap(ShoppingCartInfoRequestVo.SendGoods::getGoodsId, ShoppingCartInfoRequestVo.SendGoods::getQty));

        //goodsId -> originalPrice
        Map<String, Long> OriginalPrice = sendGoods.get(0)
                .getSendGoods()
                .stream()
                .collect(Collectors.toMap(CalculationSharingDiscountResponseDto.CalculationDiscountResult.SendActivity.SendGoods::getGoodsId, CalculationSharingDiscountResponseDto.CalculationDiscountResult.SendActivity.SendGoods::getOriginalPrice));

        //goodsId->nowPrice
        Map<String, Long> newPrice = sendGoods.get(0)
                .getSendGoods()
                .stream()
                .collect(Collectors.toMap(CalculationSharingDiscountResponseDto.CalculationDiscountResult.SendActivity.SendGoods::getGoodsId, CalculationSharingDiscountResponseDto.CalculationDiscountResult.SendActivity.SendGoods::getNowPrice));

        for (String str : map.keySet()) {
            Integer qty = map.get(str);
            if (OriginalPrice.get(str) != null && OriginalPrice.get(str) != 0) {
                totalDiscountPrice += qty * (OriginalPrice.get(str) - newPrice.get(str));
                totalNowPrice      += qty * newPrice.get(str);
            }
        }
        shoppingCartGoodsResponseVo.setTotalAmount(discountResult.getTotalAmount() + totalNowPrice);
        shoppingCartGoodsResponseVo.setTotalDiscountAmount(shoppingCartGoodsResponseVo.getTotalDiscountAmount() + totalDiscountPrice);
    }

    /**
     * 构建加价购商品校验参数
     *
     * @param shoppingCartInfoRequestVo 入参
     * @return 返回商品
     */
    public List<CreateOrderVo.PremiumExchangeActivity.Product> buildPremiumExchangeActivityProduct(ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {

        List<ShoppingCartInfoRequestVo.SendGoods> sendGoods = shoppingCartInfoRequestVo.getSendGoods();
        List<String> goodsIds = sendGoods
                .stream()
                .map(ShoppingCartInfoRequestVo.SendGoods::getGoodsId)
                .collect(Collectors.toList());

        Map<String, ShoppingCartInfoRequestVo.SendGoods> goodQtyMap = sendGoods
                .stream()
                .collect(Collectors.toMap(ShoppingCartInfoRequestVo.SendGoods::getGoodsId, Function.identity(), (k1, k2) -> k1));


        List<ProductBeanDTO> productBeanList = assortmentSdkService.getProductsInfoSdk(shoppingCartInfoRequestVo.getPartnerId()
                , shoppingCartInfoRequestVo.getShopId(), goodsIds,shoppingCartInfoRequestVo.getMenuType(), shoppingCartBaseService);

        if (CollectionUtils.isEmpty(productBeanList)) {
            throw new ServiceException(ResponseResult.PREMIUM_EXCHANGE_ACTIVITY_NOT_EXIST);
        }

        return productBeanList.stream().map(productBean ->{
            CreateOrderVo.PremiumExchangeActivity.Product product = new CreateOrderVo.PremiumExchangeActivity.Product();
            List<ProductBeanDTO.SkuProductBean> skuList = productBean.getSkuList();
            List<String> skuIds = null;
            if (null!=skuList) {
                skuIds = skuList.stream().map(ProductBeanDTO.SkuProductBean::getSkuId).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(skuIds)) {
                for (String skuId : skuIds) {
                    ShoppingCartInfoRequestVo.SendGoods sendGood = goodQtyMap.get(skuId);
                    if (null != sendGood) {
                        product.setQty(sendGood.getQty());
                        product.setSpuId(productBean.getPid());
                        product.setSkuId(sendGood.getGoodsId());
                        product.setStatus(productBean.getStatus());
                        break;
                    }
                }
            }
            else {
                ShoppingCartInfoRequestVo.SendGoods sendGood = goodQtyMap.get(productBean.getPid());
                if (null != sendGood) {
                    product.setQty(sendGood.getQty());
                    product.setSpuId(sendGood.getGoodsId());
                    product.setSkuId(sendGood.getGoodsId());
                    product.setStatus(productBean.getStatus());
                }
            }
            return product;
        }).collect(Collectors.toList());
    }



    /**
     * check加价购
     *
     * @param additionalProducts     购物车添加的加价购商品
     * @param additionalActivityList 加价购活动
     * @return
     */
    private ResponseResult checkAdditionalGoods(List<CreateOrderVo.PremiumExchangeActivity.Product> additionalProducts
            , List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.SendActivity> additionalActivityList) {
        //无加价购活动
        if (CollectionUtils.isEmpty(additionalActivityList)) {
            return ResponseResult.PREMIUM_EXCHANGE_ACTIVITY_NOT_EXIST;
        }
        //加价购活动中换购商品为空
        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.SendActivity> additionalActivity = additionalActivityList
                .stream()
                .filter(activity -> ObjectUtils.equals(ActivityTypeEnum.TYPE_81.getCode(), activity.getActivityType()))
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(additionalActivity)) {
            return ResponseResult.PREMIUM_EXCHANGE_ACTIVITY_NOT_EXIST;
        }
        //购物车中总加价购数量>每单可换购总数量
        Integer totalAdditionalProductCount = additionalProducts.stream().mapToInt(CreateOrderVo.PremiumExchangeActivity.Product::getQty).sum();
        if (totalAdditionalProductCount > additionalActivity.get(0).getMaxNum()) {
            return ResponseResult.PREMIUM_EXCHANGE_GOODS_OUT_OF_LIMIT;
        }
        //加价购活动中的换购商品列表Map
        Map<String, CalculationSharingDiscountResponseDto.CalculationDiscountResult.SendActivity.SendGoods> sendGoodsMap = additionalActivity.get(0).getSendGoods()
                .stream()
                .collect(Collectors.toMap(CalculationSharingDiscountResponseDto.CalculationDiscountResult.SendActivity.SendGoods::getGoodsId, Function.identity(), (k1, k2) -> k1));
        for (CreateOrderVo.PremiumExchangeActivity.Product product : additionalProducts) {
            if (ShoppingCartConstant.OFF_LINE_PRODUCT.equals(product.getStatus()) || ShoppingCartConstant.SOLD_OUT_PRODUCT.equals(product.getStatus())) {
                return ResponseResult.PREMIUM_EXCHANGE_ACTIVITY_NOT_EXIST;
            }
            if (ShoppingCartConstant.NOT_ON_LINE_PRODUCT.equals(product.getStatus())) {
                return ResponseResult.PREMIUM_EXCHANGE_ACTIVITY_NOT_ON_LINE;
            }
            // 购物车中加价购商品不在活动商品列表中 或  每个商品的换购数量>活动限制数量
            CalculationSharingDiscountResponseDto.CalculationDiscountResult.SendActivity.SendGoods sendGoods = Objects.isNull(sendGoodsMap.get(product.getSkuId())) ? sendGoodsMap.get(product.getSpuId()) : sendGoodsMap.get(product.getSkuId());
            if (Objects.isNull(sendGoods)) {
                return ResponseResult.PREMIUM_EXCHANGE_ACTIVITY_NOT_EXIST;
            }
            if (product.getQty() > sendGoods.getSendNumber()) {
                return ResponseResult.PREMIUM_EXCHANGE_GOODS_OUT_OF_LIMIT;
            }
        }
        return ResponseResult.SUCCESS;
    }
}