package cn.freemud.demo.entities.bo.goods.update;

import cn.freemud.demo.entities.bo.goods.BaseBo;
import cn.freemud.demo.entities.bo.goods.ManagerServiceBO;
import cn.freemud.entities.vo.CartGoods;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;

@Data
public class UpdateAddGoodsBO extends BaseBo {


    @NotEmpty(message = "spuId不能为空")
    private String spuId;

    private String skuId;

    /**
     * 更新后商品数量
     */
    @NotNull(message = "qty不能为空")
    private Integer qty;


    /**
     * 购物车一行的ID
     */
    @NotEmpty(message = "cartGoodsUid不能为空")
    private String cartGoodsUid;

    private CartGoods addGoods;


    /**
     * 微信appId
     */
    @NotEmpty(message = "appId不能为空")
    private String appId;

    /**
     * 收货地址ID、svc卡支付外卖订单必传
     */
    private String receiveId;

    /**
     * 操作类型 1= 添加商品券 2=加价购
     */
    private Integer operationType;

    /**
     * 优惠券号
     */
    private String couponCode;

    private String wxappid;

    /**
     * 下单类型 CreateOrderType 外卖、到店、商城
     */
    private Integer orderType;

    /**
     * 渠道类型 OrderChannelType
     */
    private String channelType;

    /**
     * 购物车版本号（拼单）
     */
    private Integer carVer;

    private String tableNumber;




}
