package cn.freemud.service.thirdparty;

import cn.freemud.annotations.LogIgnoreFeign;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.delivery.GetFilterPartnerResponse;
import cn.freemud.entities.dto.ecology.*;
import cn.freemud.entities.dto.openplatform.OrderGetPartnerRequest;
import cn.freemud.entities.dto.wechat.GetAuthorizerRequestDto;
import cn.freemud.entities.dto.wechat.GetTokenResponseDto;
import cn.freemud.entities.vo.SendOrderCountsMsg;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

/**
 * 生态服务
 * @author: kai.ding
 * @date:  
 */
@FeignClient(name = "ECOLOGY-ADMIN-APPLICATION", url = "${saas.ecology.admin.application.feign.url}")
public interface EcologyAdminApplicationClient {

    /**
     * 获取虚拟门店
     */
    @LogIgnoreFeign(logMessage="getBuyBindVirtualStore")
    @PostMapping(value = "ecology/api/app/info/getBuyBindVirtualStore", produces = MediaType.APPLICATION_JSON_VALUE ,consumes = MediaType.APPLICATION_JSON_VALUE )
    BaseResponse<VirtualBindStoreResponse> getBuyBindVirtualStore(@RequestBody VirtualStoreRequest virtualStoreRequest);

    @LogIgnoreFeign(logMessage="getAuthorizerAccessToken")
    @PostMapping(value = "/ecology/api/getAuthorizerAccessToken")
    GetTokenResponseDto getAuthorizerAccessToken(@RequestBody GetAuthorizerRequestDto request);

    @LogIgnoreFeign(logMessage="subscribeMessage")
    @PostMapping(value = "/ecology/api/subscribeMessage/send")
    SubscribeMessageResponse subscribeMessage(SubscribeMessageRequest request);

    @LogIgnoreFeign(logMessage="sendTemplateMessage")
    @PostMapping(value = "/ecology/api/templateMessage/send")
    SendMessageResponse sendTemplateMessage(SendMessageRequest request);

    /**
     * 上报微信 有数 统计数据
     *
     * @param orderCounts
     * @return
     */
    @LogIgnoreFeign(logMessage="addOrderSum")
    @PostMapping("/ecology/api/tencent/data/reporting/addOrderSum")
    BaseResponse addOrderSum(@RequestBody SendOrderCountsMsg orderCounts);


    /**
     * 获取需要 上报腾讯有数的 商户号
     *
     * @return
     */
    @LogIgnoreFeign(logMessage="getFilterPartner")
    @PostMapping("/ecology/api/tencent/data/reporting/getFilterPartner")
    BaseResponse<GetFilterPartnerResponse> getFilterPartner(@RequestBody OrderGetPartnerRequest request);
}
