package com.freemud.application.sdk.api.ordercenter.entities.extinfo;

import lombok.Data;

import java.util.List;

@Data
public class OrderProductExtInfo {

    /**
     * 属性名称 多糖/冷/常温
     */
    private String attributeNames;

    /**
     * 属性英文名称 多糖/冷/常温
     */
    private String attributeForeignNames;

    /**
     * 是否是套餐内固定商品
     */
    private Boolean isFixedProduct;

    /**
     * 第三方商品规格ID
     */
    private String thirdProductSpecId;

    /**
     * 第三方商品属性ID
     */
    private String thirdProductPropertyId;

    /**
     * 第三方品类id
     */
    private String thirdCategoryId;

    /** 商品组 **/
    private List<ProductGroupVo> productGroupList;

    /** 是否主食 **/
    private Integer stapleFood;

    /**
     * 商品绑定的券活动（买券虚拟订单才有）
     */
    private List<ProductBindingCouponType> productBindingCoupons;

    /**
     * 商品统计分类编号
     */
    private String thirdCensusCategoryId;

    /**
     * 商品统计分类名称
     */
    private String thirdCensusCategoryName;

    private double tax;

    private String taxId;

    private List<OrderSpecialExtraAttrRequest> specialAttrs;

    /**
     * 购物车行uid
     */
    private String cartGoodsUid;

    /**
     * 拼单买一赠一标记赠品是那个商品送的 originalGoodsUid
     */
    private String originalGoodsUid;

    /**
     * 是否需要积分
     */
    private Boolean needBonus;
    /**
     * 拆分前所属序列
     */
    private String splitIndex;

    private Long productGroupId;

    /**
     * 虚拟商品发券id
     */
    private String cardId;

    /**
     * 虚拟商品种子券号
     */
    private String cardCode;
    /**
     * 是否是月享卡商品
     */
    private Integer isMonthCard = 0;
    /**
     * 是否是买3赠1券商品
     */
    private Integer isB3S1Coupon = 0;

    /**
     * 是否赠品
     */
    private Boolean isSendGoods;

    //积分商品活动使用总积分
    private Long score;

}
