package cn.freemud.entities.dto.pay;

import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class UnifiedOrderRequestDto {

    /**
     *      * 	{"amount":1800,"body":"蜜雪冰城900507店","businessDate":"20210831","clientCode":130465,"foodOrderType":"pre_order",
     *      * 	"notifyUrl":"http://open-store-order-application-service.open-store.svc:9212/order/newPaySuccessCallback","openId":"2088332790804910",
     *      * 	"operatorId":"1","partnerId":2080,"payTimeOutTime":"25","products":[{"id":"209430924058928948","name":"鲜橙益菌多","price":900,"quantity":1},
     *      * 	{"id":"209516210115815203","name":"芝士奶盖红茶","price":900,"quantity":1}],"stationId":"1","storeId":"900507","transId":"22057814343976884800004",
     *      * 	"ver":"2","vipAmount":0}
     */


    private String ver = "2";
    private Integer reqtype;
    private String unifyid;
    private String partnerId;
    private String storeId;
    private String stationId = "1";
    private String operatorId = "1";
    private String transId;
    private String openId;
    private String businessDate;
    private Long clientCode;
    private Long amount;
    private Long undisAmount;
    private String goodsTag;
    private List<PayProductDto> products;
    private String body;
    private String payCode;
    private String notifyUrl;
    private Long vipAmount = 0L;
    private String foodOrderType;
    private Integer invoiceFlag;
    private Map<String, String> extendParams;
    private String divideDetail;
    private String payTimeOutTime;
    private Long merchantDiscount;

    /**
     * 小程序appid
     */
    private String subAppid;
    /**
     * 支付类型编码 TWX:微信 TZFB:支付宝
     */
    private String payTypeCode;

}
