/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: WebUtil
 * @Package cn.freemud.util
 * @Description:
 * @author: liming.guo
 * @date: 2018/7/20 18:14
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.utils;

import org.apache.commons.lang.StringUtils;

import java.awt.geom.Point2D;
import java.util.List;

public class EmojiUtil {
    public static String filterEmoji(String source) {
        return source.replaceAll("[\\ud800\\udc00-\\udbff\\udfff\\ud800-\\udfff]", "");
    }

    /**
     * 过滤emoji 或者 其他非文字类型的字符
     *
     * @param source 原字符串
     * @param slipStr Emoji表情替换成的字符串
     * @return 过滤后的字符串
     */
    public static String filterEmoji(String source, String slipStr) {
        if (StringUtils.isBlank(source)) {
            return source;
        }
        StringBuilder buf = new StringBuilder(source.length());
        int len = source.length();
        for (int i = 0; i < len; i++) {
            char codePoint = source.charAt(i);
            if (isEmojiCharacter(codePoint)) {
                buf.append(codePoint);
            } else {
                buf.append(slipStr);
            }
        }
        return buf.toString();
    }

    private static boolean isEmojiCharacter(char codePoint) {
        return (codePoint == 0x0)
                || (codePoint == 0x9)
                || (codePoint == 0xA)
                || (codePoint == 0xD)
                || ((codePoint >= 0x20) && (codePoint <= 0xD7FF))
                || ((codePoint >= 0xE000) && (codePoint <= 0xFFFD))
                || ((codePoint >= 0x10000) && (codePoint <= 0x10FFFF));
    }
}
