package cn.freemud.service.impl.mcoffee.calculation;


import cn.freemud.adapter.ShoppingCartConvertAdapter;
import cn.freemud.entities.dto.calculate.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.vo.CartGoods;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


/**
 * All rights Reserved, Designed By sunary.site
 *
 * @version v1.0
 * @Title: IntelliJ IDEA
 * @Package cn.freemud.service.impl.mcoffee.calculation
 * @Description: 请简单描述下这个类是做什么用的
 * @author: yu.sun
 * @date: 2020-10-21 00:56:45
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 */
@Service
public class MaterialCalculation {
    @Autowired
    private ShoppingCartConvertAdapter shoppingCartConvertAdapter;

    public void updateShoppingCartGoodsApportion(ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult, List<CartGoods> cartGoodsList) {
        HashMap<String, MaterialApportion> map = getApportionGoodsDetail(calculationDiscountResult);

        if (map.size() > 0) {
            String pk = "";
//            for (CartGoods product : cartGoodsList) {
//                if (CollectionUtils.isEmpty(product.getProductMaterialList())) {
//                    continue;
//                }
//                for (CartGoods.MaterialGoods materialGoods : product.getProductMaterialList()) {
//                    pk = shoppingCartConvertAdapter.jointPk(product.getCartGoodsUid(), materialGoods.getSpuId());
//                    MaterialApportion material = map.get(pk);
//                    if ((material == null) || (material != null && material.getTotalDiscountAmount().intValue() == 0)) {
//                        continue;
//                    }
//                    List<ActivityDiscountsDto> activityDiscountsDtos = materialGoods.getActivityDiscountsDtos();
//                    if (CollectionUtils.isEmpty(activityDiscountsDtos)) {
//                        activityDiscountsDtos = new ArrayList<>();
//                    }
//                    //设置行记录参加的活动及总优惠
//                    if (CollectionUtils.isNotEmpty(material.getDetails())) {
//                        for (ApportionDetails detail : material.getDetails()) {
//                            ActivityDiscountsDto activityDiscountsDto = new ActivityDiscountsDto();
//                            activityDiscountsDto.setActivityCode(detail.getActivityCode());
//                            activityDiscountsDto.setActivityName(detail.getActivityName());
//                            activityDiscountsDto.setActivityType(detail.getActivityType());
//                            activityDiscountsDto.setDiscountAmount(detail.getAmount().intValue());
//                            activityDiscountsDtos.add(activityDiscountsDto);
//                        }
//                    }
//                    materialGoods.setActivityDiscountsDtos(activityDiscountsDtos);
//                    materialGoods.setTotalDiscountAmount(material.getTotalDiscountAmount());
//                    product.setProductType(GoodsTypeEnum.MATERIAL.getGoodsType());
//                }
//            }
        }
//        //将小料的价格累加到商品行上
//        for (ShoppingCartGoodsDto.CartGoodsDetailDto product : products) {
//            if (CollectionUtils.isEmpty(product.getMaterialList())) {
//                continue;
//            }
//            for (ShoppingCartGoodsDto.CartGoodsDetailDto.MaterialGoods materialGoods : product.getMaterialList()) {
//                product.setSalePrice(product.getSalePrice() + materialGoods.getSalePrice());//现金
//                product.setOriginalPrice(product.getOriginalPrice() + materialGoods.getOriginalPrice());
//                product.setTotalDiscountAmount(product.getTotalDiscountAmount() + materialGoods.getTotalDiscountAmount());
//                product.setProductType(GoodsTypeEnum.MATERIAL.getGoodsType());
//            }
//        }
    }

    /**
     * 提取促销均摊
     *
     * @param calculationDiscountResult
     * @return
     */
    private HashMap<String, MaterialApportion> getApportionGoodsDetail(ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult) {
        HashMap<String, MaterialApportion> mApportion = new HashMap<>();
        // 遍历促销
        if (calculationDiscountResult == null || CollectionUtils.isEmpty(calculationDiscountResult.getApportionGoods())) {
            return mApportion;
        }
        String pk = "";
        for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods apportionGood : calculationDiscountResult.getApportionGoods()) {
            if (CollectionUtils.isEmpty(apportionGood.getSmallMaterial())) {
                continue;
            }
            for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.Material material : apportionGood.getSmallMaterial()) {

                if (material.getApportionAmount() == 0) {
                    continue;
                }
                pk = shoppingCartConvertAdapter.jointPk(apportionGood.getCartGoodsUid(), material.getGoodsId());
                if (mApportion.get(pk) == null) {
                    MaterialApportion materialApportion = new MaterialApportion();
                    materialApportion.setGoodsId(material.getGoodsId());
                    materialApportion.setTotalDiscountAmount(material.getApportionAmount() * apportionGood.getGoodsQuantity());
                    materialApportion.setPk(pk);
                    ArrayList<ApportionDetails> apportionDetailsList = new ArrayList<>();
                    if (CollectionUtils.isNotEmpty(material.getApportionDetails())) {
                        for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.ApportionDetails apportionDetail : material.getApportionDetails()) {
                            ApportionDetails apportionDetails = new ApportionDetails();
                            apportionDetails.setActivityName(apportionDetail.getActivityName());
                            apportionDetails.setActivityCode(apportionDetail.getActivityCode());
                            apportionDetails.setActivityType(apportionDetail.getActivityType());
                            apportionDetails.setAmount(apportionDetail.getActivityApportionAmount()*apportionGood.getGoodsQuantity());
                            apportionDetailsList.add(apportionDetails);
                        }
                        materialApportion.setDetails(apportionDetailsList);
                    }
                    mApportion.put(pk, materialApportion);
                    continue;
                }
                MaterialApportion apportion = mApportion.get(pk);
                apportion.setTotalDiscountAmount(apportion.getTotalDiscountAmount() + material.getApportionAmount() * apportionGood.getGoodsQuantity());
                List<ApportionDetails> details = apportion.getDetails();
                for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.ApportionDetails apportionDetail : material.getApportionDetails()) {
                    //累加不同的均摊活动
                    if (apportion.getDetails().stream().filter(e -> e.getActivityCode().equals(apportionDetail.getActivityCode())).count() == 0) {
                        ApportionDetails apportionDetails = new ApportionDetails();
                        apportionDetails.setActivityName(apportionDetail.getActivityName());
                        apportionDetails.setActivityCode(apportionDetail.getActivityCode());
                        apportionDetails.setActivityType(apportionDetail.getActivityType());
                        apportionDetails.setAmount(apportionDetail.getActivityApportionAmount()*apportionGood.getGoodsQuantity());
                        details.add(apportionDetails);
                    }
                    //相同的均摊累加金额
                    else {
                        for (ApportionDetails detail : apportion.getDetails()) {
                            if (detail.getActivityCode().equals(apportionDetail.getActivityCode())) {
                                detail.setAmount(detail.getAmount()+apportionDetail.getActivityApportionAmount()*apportionGood.getGoodsQuantity());
                            }
                        }
                    }
                    apportion.setDetails(details);
                }
                mApportion.put(pk, apportion);
            }
        }
        return mApportion;
    }

    @Data
    private class MaterialApportion {
        private String goodsId;
        //优惠金额
        private Integer totalDiscountAmount;
        private List<ApportionDetails> details;
        private String pk;
    }

    @Data
    public class ApportionDetails {
        private String activityCode;
        private String activityName;
        private Integer activityType;
        private Long amount;
    }

    @Data
    @NoArgsConstructor
    public static class Material {
        /**
         * 均摊金额
         */
        private Integer apportionAmount;
        /**
         * 购物车行记录
         */
        private String cartGoodsUid;

        /**
         * 商品id
         */
        private String goodsId;

        /**
         * 商品数量
         */
        private Integer goodsQuantity;

        /**
         * 赠送商品现价（单位：分）（加价换购时表示需要加的价格）
         */
        private Long nowPrice;

        /**
         * 商品原价（分）
         */
        private Long originalPrice;
        private List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.ApportionDetails> apportionDetails;

    }
}
