package cn.freemud.management.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.response.order.OrderManagerResponse;
import cn.freemud.management.util.ResponseUtil;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;

/**
 * 订单操作接口
 */
public interface OrderManagerService {

    /**
     * 接单
     * @param request 请求参数
     * @param orderBean 订单实体
     * @return
     */
    default BaseResponse<OrderManagerResponse> orderConfirm(OrderManagerRequest request, OrderBeanV1 orderBean){
        return ResponseUtil.success();
    }

    /**
     * 制作完成
     * @param request
     * @param orderBean
     * @return
     */
    default BaseResponse<OrderManagerResponse> orderDone(OrderManagerRequest request, OrderBeanV1 orderBean){
        return ResponseUtil.success();
    }

    /**
     * 订单配送
     * @param request
     * @param orderBean
     * @return
     */
    default BaseResponse<OrderManagerResponse> orderDelivery(OrderManagerRequest request, OrderBeanV1 orderBean){
        return ResponseUtil.success();
    }

    /**
     * 订单完成
     * @param request
     * @param orderBean
     * @return
     */
    default BaseResponse<OrderManagerResponse> orderAffirm(OrderManagerRequest request, OrderBeanV1 orderBean){
        return ResponseUtil.success();
    }

    /**
     * 拒单
     * @param request
     * @param orderBean
     * @return
     */
    default BaseResponse<OrderManagerResponse> orderReject(OrderManagerRequest request, OrderBeanV1 orderBean){
        return ResponseUtil.success();
    }

    /**
     * 同意退款
     * @param request
     * @param orderBean
     * @return
     */
    default BaseResponse<OrderManagerResponse> orderAgreeRefund(OrderManagerRequest request, OrderBeanV1 orderBean){
        return ResponseUtil.success();
    }

    /**
     * 拒绝退款
     * @param request
     * @param orderBean
     * @return
     */
    default BaseResponse<OrderManagerResponse> orderRejectRefund(OrderManagerRequest request, OrderBeanV1 orderBean){
        return ResponseUtil.success();
    }

    /**
     * 取消订单
     */
    default BaseResponse<OrderManagerResponse> orderCancel(OrderManagerRequest request, OrderBeanV1 orderBean){
        return ResponseUtil.success();
    }


}
