package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.ConfirmOrderDto;
import cn.freemud.entities.dto.QueryOrdersResponseDto;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.entities.vo.OrderAffirmRequestVO;
import cn.freemud.entities.vo.OrderReceiveRequestVO;
import cn.freemud.entities.vo.PaysuccessNoticeMessage;
import cn.freemud.entities.vo.*;
import cn.freemud.entities.vo.encircle.CreateReserveOrderVo;
import cn.freemud.entities.vo.encircle.EmptyTableNumberVo;
import cn.freemud.entities.vo.encircle.EncircleReserveBaseVo;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;

import java.util.Map;

/**
 * 商城订单业务操作类
 * @version V1.0
 * @author: kai.ding
 * @date:
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * All rights Reserved, Designed By www.freemud.cn
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface MallOrderService {

    /**
     * 创建订单
     */
     BaseResponse createOrder(CreateOrderVo createOrderVo);

     /**
      * 订单确认完成
      */
     @Deprecated
     BaseResponse orderAffirm(OrderAffirmRequestVO requestVO);

     /**
      * 支付回调
      */
     String paySuccessCallback(PaysuccessNoticeMessage message, ConfirmOrderDto confirmOrderDto, Map<String, OrderBeanV1> orderBeans);

    /**
     * 订单确认完成
     */
    BaseResponse orderReceive(OrderReceiveRequestVO requestVO);



     /**
      * 保存退货物流信息
      *
      * @param editAfterSalesExpressVo
      * @return
      */
     BaseResponse saveAfterSalesExpress(EditAfterSalesExpressVo editAfterSalesExpressVo);

}
