package cn.freemud.entities.vo;

import cn.freemud.entities.dto.ProductGroupDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
public class PremiumExchangeResponseVo {
    /**
     * 0-不需要参加活动，1-参加活动
     */
    @ApiModelProperty(value = "0-不需要参加活动，1-参加活动")
    private Integer resultCode;

    @ApiModelProperty(value = "resultMsg")
    private String resultMsg;
    /**
     * 每个订单最大商品数量
     */
    @ApiModelProperty(value = "每个订单最大商品数量")
    private Integer maxNum;

    /**
     * 活动code
     */
    @ApiModelProperty(value = "活动code")
    private String activityCode;

    /**
     * 活动名称
     */
    @ApiModelProperty(value = "活动名称")
    private String activityName;

    /**
     * 展示形式 0:订单结算页嵌入 5:订单结算页弹窗
     */
    private Integer showType;

    List<PremiumExchangeProduct> products;

    @Data
    public static class PremiumExchangeProduct {

        @ApiModelProperty(value = "spuId")
        private String spuId;
        @ApiModelProperty(value = "skuId")
        private String skuId;
        @ApiModelProperty(value = "skuName")
        private String skuName;
        /**
         * 商品原价（分） /activity/query入参
         */
        @ApiModelProperty(value = "商品原价（分） /activity/query入参")
        private Long originalPrice;
        /**
         * 现价（分）
         */
        @ApiModelProperty(value = "现价（分）")
        private Long nowPrice;
        /**
         * 单品限购
         */
        @ApiModelProperty(value = "单品限购")
        private Integer number;
        /**
         * 图片
         */
        @ApiModelProperty(value = "图片")
        private String picture;

        /**
         * 商品ID
         */
        @ApiModelProperty(value = "商品ID")
        private String pid;
        /**
         * spu商品名称
         */
        @ApiModelProperty(value = "spu商品名称")
        private String spuName;
        /**
         * 商品名称
         */
        @ApiModelProperty(value = "商品名称")
        private String name;
        /**
         * 默认spu销售价
         */
        @ApiModelProperty(value = "默认spu销售价")
        private Long defaultPrice;
        /**
         * 最终价格
         */
        @ApiModelProperty(value = "最终价格")
        private Long finalPrice;

        /**
         * 商品货号
         */
        @ApiModelProperty(value = "商品货号")
        private String artNo;
        /**
         * 属性信息
         */
        @ApiModelProperty(value = "属性信息")
        List<ProductGroupDto> productGroups;
        /**
         * SKU信息
         */
        @ApiModelProperty(value = "SKU信息")
        private List<SpuProductVo.SkuProductVo> skuList;
        /**
         * 商品规格信息
         */
        @ApiModelProperty(value = "商品规格信息")
        private List<SpuProductVo.SpecificationGroupVo> specificationGroupList;
        /**
         * 商品标签信息
         */
        @ApiModelProperty(value = "商品标签信息")
        List<SpuProductVo.ProductLabel> productLabels;

        /**
         * 折扣标签
         */
        @ApiModelProperty(value = "折扣标签")
        List<ProductDiscountLabel> productDiscountLabels;
        /**
         * 该字段为老版本小程序使用商品类型，需要兼容hasSKU一起使用，不能修改，1.9.2商品套餐之后使用新版本类型字段
         * 商品类型  1=普通商品,2=附加商品,3=组合商品，4=固定套餐，5=组合套餐
         */
        @ApiModelProperty(value = "该字段为老版本小程序使用商品类型，需要兼容hasSKU一起使用，不能修改，1.9.2商品套餐之后使用新版本类型字段 商品类型  1=普通商品,2=附加商品,3=组合商品，4=固定套餐，5=组合套餐")
        private Integer type;

        /**
         * 1.9.2商品套餐新增商品类型 后续C端小程序使用该字段获取商品类型
         * 1:单品无属性
         * 2:单品有属性
         * 7:套餐
         * 8:多规格有属性
         * 10:多规格无属性
         */
        @ApiModelProperty(value = "1.9.2商品套餐新增商品类型 后续C端小程序使用该字段获取商品类型 1:单品无属性  \n" +
                "2:单品有属性  \n" +
                "7:套餐     \n" +
                "8:多规格有属性 \n" +
                "10:多规格无属性")
        private Integer productType;
        /**
         * 描述
         */
        @ApiModelProperty(value = "描述")
        private String specification;
        /**
         * 备注
         */
        @ApiModelProperty(value = "备注")
        private String remark;
        /**
         * 商品排序
         */
        @ApiModelProperty(value = "商品排序")
        private int sequence;
        /**
         * 商品数量
         */
        @ApiModelProperty(value = "商品数量")
        private Integer qty;
        /**
         * 商品状态   1 下架 2 上架 3 售罄 ，已卖光
         */
        @ApiModelProperty(value = "商品状态   1 下架 2 上架 3 售罄 ，已卖光")
        private Integer status;
        /**
         * 状态描述
         */
        @ApiModelProperty(value = "状态描述")
        private String statusDesc;
        /**
         * 是否有规格信息
         */
        @ApiModelProperty(value = "是否有规格信息")
        private boolean hasSku;
        /**
         * 腾讯商品推荐id
         */
        @ApiModelProperty(value = "腾讯商品推荐id")
        private String traceId;
        /**
         * 是否有折扣信息
         */
        @ApiModelProperty(value = "是否有折扣信息")
        private boolean hasDiscount;
        /**
         * 每笔订单限制购买数量
         */
        @ApiModelProperty(value = "每笔订单限制购买数量")
        private Integer limitPerOrder;
        /**
         * 折扣信息描述
         */
        @ApiModelProperty(value = "折扣信息描述")
        private String discountDesc;

        /**
         * 商品券生效开始时间
         */
        @ApiModelProperty(value = "商品券生效开始时间")
        private String startDate;
        /**
         * 商品券生效截止时间
         */
        @ApiModelProperty(value = "商品券生效截止时间")
        private String endDate;

        @ApiModelProperty(value = "stockLimit")
        private Integer stockLimit;

        /**
         * 1.5.5版本添加
         * 商品参与活动类型(61:买一赠一)
         */
        @ApiModelProperty(value = "1.5.5版本添加\n" +
                "商品参与活动类型(61:买一赠一)")
        private Integer activityType;
        /**
         * 1.5.5版本添加
         * 商品参与活动名称
         */
        @ApiModelProperty(value = "1.5.5版本添加\n" +
                "商品参与活动名称")
        private String activityName;

        /**
         * 商品描述信息
         */
        @ApiModelProperty(value = "商品描述信息")
        private String detailText;

        /**
         * 活动商品描述
         */
        @ApiModelProperty(value = "活动商品描述")
        private String goodsDesc;

        @Data
        @NoArgsConstructor
        public static class ProductLabel {
            /**
             * 标签名称
             */
            @ApiModelProperty(value = "标签名称")
            private String labelName;

        }

        @Data
        @NoArgsConstructor
        public static class ProductDiscountLabel {
            /**
             * 标签名称
             */
            @ApiModelProperty(value = "标签名称")
            private String labelName;

            /**
             * 标签类型  1:折扣标签  2:限购标签
             */
            @ApiModelProperty(value = "标签类型  1:折扣标签  2:限购标签")
            private Integer labelType;

        }

        @NoArgsConstructor
        @Data
        public static class SkuProductVo {
            /**
             * sku id
             */
            @ApiModelProperty(value = "sku id")
            private String skuId;
            /**
             * sku 名称
             */
            @ApiModelProperty(value = "sku 名称")
            private String skuName;
            /**
             * 最终价格
             */
            @ApiModelProperty(value = "最终价格")
            private Long finalPrice;
            /**
             * 市场价
             */
            @ApiModelProperty(value = "市场价")
            private Long originalPrice;
            /**
             * sku 状态
             */
            @ApiModelProperty(value = "sku 状态")
            private Integer status;
            /**
             * 状态描述
             */
            @ApiModelProperty(value = "状态描述")
            private String statusDesc;
            /**
             * 规格id
             */
            @ApiModelProperty(value = "规格id")
            private String[] specValueId;

            /**
             * 活动类型
             */
            @ApiModelProperty(value = "活动类型")
            private Integer activityType;
            /**
             * 活动名称
             */
            @ApiModelProperty(value = "活动名称")
            private String activityName;
        }

        @NoArgsConstructor
        @Data
        public static class SpecificationGroupVo {

            /**
             * 规格名称 杯型 ，加料
             */
            @ApiModelProperty(value = "规格名称 杯型 ，加料")
            private String specName;
            /**
             * 规格id 1001
             */
            @ApiModelProperty(value = "规格id 1001")
            private String specId;
            /**
             * 规格信息
             */
            @ApiModelProperty(value = "规格信息")
            private List<SpuProductVo.SpecificationGroupVo.SpecValueVo> specValueVos;

            @NoArgsConstructor
            @Data
            public static class SpecValueVo {
                /**
                 * 规格id 1001
                 */
                @ApiModelProperty(value = "规格id 1001")
                private String specId;
                /**
                 * 规格值 id   100100
                 */
                @ApiModelProperty(value = "规格值 id   100100")
                private String specValueId;
                /**
                 * 规格值名称  大杯，小杯
                 */
                @ApiModelProperty(value = "规格值名称  大杯，小杯")
                private String specValueName;
            }
        }
    }

}
