package cn.freemud.entities.db;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

@Data
@Table(name = "open_platform_partner_config")
public class OpenPlatformPartnerConfig {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 商户号
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * 业务key
     */
    @Column(name = "partner_key")
    private String partnerKey;

    /**
     * 业务value
     */
    @Column(name = "partner_value")
    private String partnerValue;

    /**
     * 0-否 1-是
     */
    private Integer state;

    /**
     * 创建人
     */
    @Column(name = "create_name")
    private String createName;

    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;
}