package cn.freemud.client;

import cn.freemud.entities.dto.GetWxappAccessTokenDto;
import cn.freemud.service.thirdparty.OpenPlatformClient;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class OpenPlatformClientTest {

    @Autowired
    private OpenPlatformClient openPlatformClient;

    @Test
    public void getAccessTokenAndTemplateId(){
        GetWxappAccessTokenDto getWxappAccessTokenDto=new GetWxappAccessTokenDto();
        getWxappAccessTokenDto.setAppId("234324");
        getWxappAccessTokenDto.setParentId(2L);
        System.out.println("json==="+openPlatformClient.getAccessTokenAndTemplateId(getWxappAccessTokenDto));
    }

}
