package cn.freemud.service.impl.calculate.promotion;

import cn.freemud.entities.dto.ActivityResponseDto;
import cn.freemud.entities.dto.BenefitBeanDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.activity.ActivityQueryResponseDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.entities.vo.ShoppingCartGoodsResponseVo;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.service.ActivityService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;

import static cn.freemud.constant.ApplicationConstant.*;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: cn.freemud.service.impl.calculate.promotion DelivierySharingService
 * @Description: 满额减配送费用
 * @author: family
 * @date: 2020/9/9
 * @Copyright: www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class DeliverySharingService {

    @Autowired
    private ActivityService activityService;


    public void deliveryResponse(CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult
            , ActivityQueryDto activityQueryDto
            , ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo
            , Long deliveryAmount) {

        DecimalFormat df = new DecimalFormat("###.##");
        List<ActivityTypeEnum> activityTypeEnums = new LinkedList<>();
        activityTypeEnums.add(ActivityTypeEnum.TYPE_14);

        ActivityQueryResponseDto activityQueryResponseDto = activityService.queryActivityByType(activityQueryDto, activityTypeEnums, null);
        ActivityResponseDto activityResponse =null;
        BenefitBeanDto beanDto=null;
        if (activityQueryResponseDto != null &&activityQueryResponseDto.getResult()!=null && activityQueryResponseDto.getResult().size()>0) {
            activityResponse = activityQueryResponseDto.getResult().get(0);
            shoppingCartGoodsResponseVo.setDiscountDeliveryActivityCode(activityResponse.getActivityCode());
            beanDto=activityResponse.getBenefits().get(0);
        }

        CalculationSharingDiscountResponseDto.CalculationDiscountResult.Discount discount=null;
        if (discountResult != null && CollectionUtils.isNotEmpty(discountResult.getDiscounts())) {
            discount = discountResult.getDiscounts().stream().filter((d) -> ActivityTypeEnum.TYPE_14.getCode().equals(d.getType())).findFirst().orElse(null);
        }
        if(discount!=null) {
            if(beanDto.getBenefitType() == 1) {
                String desc = DELIVERY_DISCOUNT_DESC2;
                shoppingCartGoodsResponseVo.setDeliveryDiscountDesc(String.format(desc, df.format(beanDto.getThresholdAmount().doubleValue() /100) ));
            }
            else {
                String desc = DELIVERY_DISCOUNT_DESC1;
                shoppingCartGoodsResponseVo.setDeliveryDiscountDesc(String.format(desc, df.format(beanDto.getThresholdAmount().doubleValue() /100) ,df.format(beanDto.getDiscountAmount().doubleValue() / 100)));
            }
            shoppingCartGoodsResponseVo.setDeliveryAmount(discountResult.getDeliveryAmount());
            shoppingCartGoodsResponseVo.setDiscountDeliveryAmount(discountResult.getDistributionFee());
            shoppingCartGoodsResponseVo.setThresholdAmount(discount.getThresholdAmount());
            shoppingCartGoodsResponseVo.setIsDiscountDelivery(true);
        }
        else {
            if (activityResponse!=null) {
                if(beanDto.getBenefitType() == 1) {
                    String desc = DELIVERY_DISCOUNT_DESC2;
                    shoppingCartGoodsResponseVo.setDeliveryDiscountDesc(String.format(desc, df.format(beanDto.getThresholdAmount().doubleValue() /100) ));
                }
                else {
                    String desc = DELIVERY_DISCOUNT_DESC1;
                    shoppingCartGoodsResponseVo.setDeliveryDiscountDesc(String.format(desc, df.format(beanDto.getThresholdAmount().doubleValue() /100 ),df.format(beanDto.getDiscountAmount().doubleValue() / 100)));
                }

                shoppingCartGoodsResponseVo.setDeliveryAmount(deliveryAmount);
                shoppingCartGoodsResponseVo.setDiscountDeliveryAmount(deliveryAmount);
                shoppingCartGoodsResponseVo.setIsDiscountDelivery(false);

            } else {
                String desc = DELIVERY_DISCOUNT_DESC3;
                shoppingCartGoodsResponseVo.setDeliveryDiscountDesc(String.format(desc, df.format(deliveryAmount.doubleValue() / 100)));
                shoppingCartGoodsResponseVo.setDeliveryAmount(deliveryAmount);
                shoppingCartGoodsResponseVo.setDiscountDeliveryAmount(deliveryAmount);
                shoppingCartGoodsResponseVo.setIsDiscountDelivery(false);
            }
        }

    }
}
