/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: QueryOrderResponse
 * @Package cn.freemud.entities.dto
 * @Description: 订单列表
 * @author: liming.guo
 * @date: 2018/5/24 17:37
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.order.response.order;

import com.freemud.application.sdk.api.ordercenter.response.OrderPayItemResp;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.AfterSalesOrderResp;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderCostResp;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInvoice;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderSettlementResp;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.List;

@NoArgsConstructor
@Data
public class QueryOrdersResponse {
    /**
     * data : {"count":3,"orders":[{"accountList":[],"address":"上海市长宁区","amount":1100,"barCounter":"","cancelReason":"","companyId":"360bb48b-5316-458a-903e-9a44c7f339b1","courierName":"","courierPhone":"","createUser":"","customerOrder":"","evaluateStatus":1,"gmtAccept":null,"gmtCreate":1527146094203,"gmtExpect":null,"gmtModified":1527146094203,"gmtPay":1527150816285,"hasRefund":false,"invoiceInfo":"","latitude":32.1232,"longitude":121.23434,"oid":"109457845547698183","orderType":0,"otherCode":"2","partition":"","payChannel":"","payChannelName":"sdf43242","payStatus":2,"payType":1,"payVoucher":"234234","phone":"15170031433","posId":"","productList":[{"customerCode":"","number":1,"opid":"0","orderId":"109457845547698183","parentProduct":"","picture":"","price":1100,"productId":"product1","productName":"奶茶","sequence":10,"specification":"中杯+常温","specificationName":"","unit":""},{"customerCode":"","number":1,"opid":"0","orderId":"109457845547698183","parentProduct":"product1","picture":"","price":0,"productId":"product2","productName":"椰果","sequence":20,"specification":"加糖","specificationName":"","unit":""}],"refundList":[],"remark":"","shopId":"0012","shopName":"上海长宁区旗舰店","source":"","sourceName":"","status":1,"takeAddress":"","type":4,"userId":"m12321332423","userName":"张三","userType":""},{"accountList":[],"address":"上海市长宁区","amount":1100,"barCounter":"","cancelReason":"","companyId":"360bb48b-5316-458a-903e-9a44c7f339b1","courierName":"","courierPhone":"","createUser":"","customerOrder":"","evaluateStatus":1,"gmtAccept":null,"gmtCreate":1527144957247,"gmtExpect":null,"gmtModified":1527144957247,"gmtPay":null,"hasRefund":false,"invoiceInfo":"","latitude":32.332243,"longitude":123.23423,"oid":"109456653362923524","orderType":0,"otherCode":"","partition":"","payChannel":"","payChannelName":"","payStatus":1,"payType":1,"payVoucher":"","phone":"15170031433","posId":"","productList":[{"customerCode":"","number":1,"opid":"0","orderId":"109456653362923524","parentProduct":"","picture":"","price":1100,"productId":"product1","productName":"奶茶","sequence":10,"specification":"中杯+常温","specificationName":"","unit":""},{"customerCode":"","number":1,"opid":"0","orderId":"109456653362923524","parentProduct":"product1","picture":"","price":0,"productId":"product2","productName":"椰果","sequence":20,"specification":"加糖","specificationName":"","unit":""}],"refundList":[],"remark":"","shopId":"0012","shopName":"上海长宁区旗舰店","source":"","sourceName":"","status":2,"takeAddress":"","type":4,"userId":"m12321332423","userName":"张三","userType":""},{"accountList":[],"address":"上海市长宁区","amount":1100,"barCounter":"","cancelReason":"","companyId":"360bb48b-5316-458a-903e-9a44c7f339b1","courierName":"","courierPhone":"","createUser":"","customerOrder":"","evaluateStatus":1,"gmtAccept":null,"gmtCreate":1527144878384,"gmtExpect":null,"gmtModified":1527144878384,"gmtPay":null,"hasRefund":false,"invoiceInfo":"","latitude":32.1232,"longitude":121.23434,"oid":"109456570669074433","orderType":0,"otherCode":"","partition":"","payChannel":"","payChannelName":"","payStatus":1,"payType":1,"payVoucher":"","phone":"15170031433","posId":"","productList":[{"customerCode":"","number":1,"opid":"0","orderId":"109456570669074433","parentProduct":"","picture":"","price":1100,"productId":"product1","productName":"奶茶","sequence":10,"specification":"中杯+常温","specificationName":"","unit":""},{"customerCode":"","number":1,"opid":"0","orderId":"109456570669074433","parentProduct":"product1","picture":"","price":0,"productId":"product2","productName":"椰果","sequence":20,"specification":"加糖","specificationName":"","unit":""}],"refundList":[],"remark":"","shopId":"0012","shopName":"上海长宁区旗舰店","source":"","sourceName":"","status":2,"takeAddress":"","type":4,"userId":"m12321332423","userName":"张三","userType":""}]}
     * errcode : 100
     * errmsg : 查询订单成功
     */

    private DataBean data;
    private int errcode;
    private String errmsg;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }


    @NoArgsConstructor
    @Data
    public static class DataBean {

        private int count;
        private Long updateTimestamp;
        private List<OrderBean> orders;


        @NoArgsConstructor
        @Data
        public static class OrderBean {
            /**
             * 取餐吗
             */
            private String pickUpGoodsNo;
            /**
             * 下单渠道 1:自营微信小程序 2:i点餐 3:自营支付宝小程序 4:自营H5 5:自营安卓APP 6:自营苹果APP 7:自营PC-WEB
             * 8:饿了么 9:饿百 10:京东 11:美团外卖 12:自营APP 13:i应用会员 14:i应用订货 15:POS 16:百度外卖 18:i拼团 19:i围餐
             */
            private String orderClient;
            /**
             * 订单异常具体描述
             */
            private String abnormalDesc;
            /**
             * 订单异常状态 0:正常（无异常）1:异常
             */
            private Integer abnormalState;

            private Integer bizType;
            /**
             * 是否需要开发票
             */
            private Boolean needInvoice;
            /**
             * 父订单编号
             */
            private String parentCode;
            /**
             * 是否是父订单
             */
            private Boolean isParent;
            /**
             * 操作人
             */
            private String operator;
            /**
             * 订单原始金额，单位分
             */
            private BigDecimal originalAmount;
            /**
             * 门店地址
             */
            private String shopAddress;
            /**
             * 收货地址
             */
            private String address;
            /**
             * 门店电话
             */
            private String shopPhone;

            /**
             * 总金额
             */
            private Long amount;
            /**
             * 用户在界面上看到的支付金额，单位分
             */
            private Long settlementAmount;
            /*
            * 实际支付金额
            */
            private Long actualPayAmount;
            /**
             * 吧台桌号
             */
            private String barCounter;
            /**
             * 取消原因
             */
            private String cancelReason;
            /**
             * 商户ID
             */
            private String companyId;
            private String courierName;
            private String courierPhone;
            private String createUser;
            private String customerOrder;
            private int evaluateStatus;
            private Long gmtAccept;
            /**
             * 自定义描述字段
             */
            private String extInfo;
            /**
             * 创建时间 时间戳
             */
            private Long gmtCreate;
            /**
             * 期望送达时间
             */
            private Long gmtExpect;
            /**
             * 更新时间 时间戳
             */
            private Long gmtModified;
            private Long gmtPay;
            /**
             * 是否有退款记录
             */
            private Boolean hasRefund;
            private String invoiceInfo;
            /**
             * 维度
             */
            private Double latitude;
            /**
             * 经度
             */
            private Double longitude;
            /**
             * 订单ID
             */
            private String oid;
            /**
             * 老版本订单类型
             */
            private Integer orderType;
            /**
             * 新订单服务订单类型
             */
            private Integer newOrderType;
            /**
             * 取餐码
             */
            private String otherCode;
            private String partition;
            private String payChannel;
            private String payChannelType;
            private String payChannelName;
            /**
             * 订单支付状态   1 未支付 2 已支付 3 已退款 4 已经部分退款 5 完成
             */
            private Integer payStatus;
            /**
             * 订单支付类型   1 线上支付 2 货到付款
             */
            private Integer payType;
            /**
             * 支付凭证 非码流水ID
             */
            private String payVoucher;
            /**
             * 手机号
             */
            private String phone;
            private String posId;
            private String remark;
            /**
             * 日订单序号
             */
            private Integer daySeq;
            private String shopId;
            /**
             * 第三方门店
             */
            private String thirdShopId;
            private String shopName;
            private String source;
            private String sourceName;
            /**
             * 订单状态  1 下单 2 待支付 3已接单 4 配送中 5 已完成 6 已取消 7 已拒单 31 制作完成
             */
            private Integer status;
            /**
             * 取餐地址
             */
            private String takeAddress;
            /**
             * 取餐排队号  订单详情使用 默认为空
             */
            private String queueIndex;
            /**
             * 订单类型   1 外卖 2 预订单 3 商城 4 打包带走 5 店内就餐
             */
            private Integer type;
            /**
             * 用户ID
             */
            private String userId;

            /**
             * 三方订单编号
             */
            private String thirdOrderCode;

            /**
             * 订单特殊类型 1:普通订单 2:拼团订单 3:秒杀订单 4:拼单订单
             */
            private Byte marketingType;


            /**
             * 退款信息
             */
            private AfterSalesOrderResp afterSalesOrderResp;

            /**
             * 用户名称
             */
            private String userName;
            private String userType;
            private List<AccountBean> accountList;
            private List<ProductBean> productList;
            private List<RefundBean> refundList;
            private List<OperationHistory> orderOperationHistoryList;

            private List<OrderSettlement> apportionDetails;

            /**
             * 订单费用信息
             */
            private List<OrderCostResp> orderCostDetailList;

            private List<OrderSettlementResp> orderSettlementDetailList;

            private AddDeliveryInfo addInfo;

            /**
             * 订单操作状态(从订单操作历史表中获取)
             */
            private String operateTakeOrderTime;
            private String operateWaitPayTime;
            private String operateReceiptTime;
            private String operateDistributionTime;
            private String operateCompleteTime;
            private String operateCalcelTime;
            private String operatePefuseTime;
            private String operateCompleteMakeTime;

            /**
             * 运单状态
             */
            private Integer deliverStatus;

            /**
             * 骑手姓名
             */
            private String riderName;
            /**
             * 骑手文案 商家自配送文案
             */
            private String riderText;
            /**
             * 骑手头像 如果是自配送，显示门店首图
             */
            private String riderPhoto;
            /**
             * 门店首图 扩展字段
             */
            private String shopImageUrl;
            /**
             * 骑手电话
             */
            private String riderPhone;
            /**
             * 签收时间 送达时间 收货时间
             */
            private String receiveTime;
            /**
             * 骑手分配时间
             */
            private String depatchTime;
            /**
             * 到店时间
             */
            private String arriveShopTime;
            /**
             * 送出时间
             */
            private String sendTime;
            /**
             * 完成时间
             */
            private String completeTime;

            /**
             * 就餐人数
             */
            private Integer dinersNumber;

            /**
             * 收件人省份
             */
            private String receiveProvince;

            /**
             * 收件人城市
             */
            private String receiveCity;

            /**
             * 收件人区
             */
            private String receiveRegion;

            /**
             * 订单重量
             */
            private BigDecimal weight;

            /**
             * 发票明细
             */
            private OrderInvoice orderInvoice;

            /*@NoArgsConstructor
            @Data
            public static class OrderCostResp {
                //订单商品ID
                private String productId;

                //商品序号
                private Integer productSeq;

                //商品ID
                private Long orderItemId;

                //费用名称
                private String costName;

                //1=包装费,2=运费,3=餐盒单价,4=餐盒数量
                private Integer costType;

                //1=订单,2=订单商品,3=售后单
                private Integer billType;

                //费用金额
                private BigDecimal costAmount;

                //备注
                private String note;

            }*/

            /**
             * 配送渠道
             */
            private String expressChannelName;

            /**
             * 签收时间 送达时间 收货时间
             */
            private Long gmtReceiveTime;

            /**
             * 完成时间
             */
            private  Long  gmtCompleteTime;
            /**
             * 下游POS商编号
             */
            private String downstreamPosCode;

            /**
             * 下游订单号
             */
            private String downstreamThirdOrderCode;


            /**
             * 混合支付list
             */
            //订单支付详情
            private List<OrderPayItem> orderPayItem;

            @NoArgsConstructor
            @Data
            public static class AddDeliveryInfo {

                /**
                 * 配送类型     SELF("self", "自配送"),
                 *              THIRD("third", "第三方配送");
                 */
                private String deliveryType;
                /**
                 * 外卖中台运单号
                 */
                private String deliveryId;
                /**
                 * 配送公司
                 */
                private String express;
                /**
                 * 配送公司编号
                 */
                private String expressNo;
                /**
                 * 运单状态
                 * -2默认值 -1:创建失败 0:待接单 1:系统接单 2:分配骑手 3:骑手到店 4:骑手取餐 5:开始配送 6:运单送达 7:运单异常 8:运单取消 9:创建配送单成功
                 */
                private Integer deliverStatus;

                private String RiderName;

                private String RiderPhone;

                private String extInfo;
            }

            @NoArgsConstructor
            @Data
            public static class ProductBean {
                /**
                 * customerCode :
                 * number : 1
                 * opid : 0
                 * orderId : 109457845547698183
                 * parentProduct :
                 * picture :
                 * price : 1100
                 * productId : product1
                 * productName : 奶茶
                 * sequence : 10
                 * specification : 中杯+常温
                 * specificationName :
                 * unit :
                 */
                /**
                 * 重量
                 */
                private BigDecimal weight;
                /**
                 * 优惠分摊金额
                 */
                private BigDecimal productSharePrice;
                private String customerCode;
                /**
                 * 商品货号，商品服务可重复
                 */
                private String productCode;
                /**
                 * 商品数量
                 */
                private int number;
                private String opid;
                /**
                 * 订单ID
                 */
                private String orderId;
                /**
                 * 商品ID
                 */
                private String productId;
                /**
                 * 父类商品ID
                 */
                private String parentProductId;
                /**
                 * 商品图片
                 */
                private String picture;
                /**
                 * 商品价格
                 */
                private Long price;
                /**
                 * 商品实际销售价格 扣除优惠价格后计算salePrice V1.5.2增加
                 */
                private Long salePrice;
                //均摊价格
                private Long settlementPrice;
                /**
                 * 商品名称
                 */
                private String productName;
                /**
                 * 商品排序
                 */
                private int sequence;
                /**
                 * 商品描述
                 */
                private String specification;
                private String specificationName;
                private String unit;
                /**
                 * 商品扩展字段 保存为
                 */
                private String addInfo;

                /**
                 * 商品属性
                 */
                private String productProperty;

                /**
                 * 数据库字段（保存套餐商品是否为固定商品）
                 */
                private String extInfo;

                /**
                 * 商品type
                 */
                private Integer productType;

                /**
                 * 当前商品的实际优惠信息
                 */
                public List<ProductDiscount> discountList;
                /**
                 * 订单商品明细ID，由订单服务生成
                 */
                private Long id;
                /**
                 * 加购人ID
                 */
                private String userId;

                /**
                 * 加购人昵称
                 */
                private String nickName;

                /**
                 * 加购人头像
                 */
                private String photoUrl;
                /**
                 * 套餐子商品
                 */
                public List<ProductBean> comboProduct;

                /**
                 * 套餐子商品
                 */
                public List<ProductBean> materialProduct;

                @NoArgsConstructor
                @Data
                public static class ProductDiscount {
                    /**
                     * 存放活动ID ，couponCode
                     */
                    private String discountId;
                    /**
                     * 存放活动名称，券名称
                     */
                    private String discountDesc;
                    /**
                     * 存放活动类型 OrderAccountType 枚举
                     */
                    private Integer discountType;
                    /**
                     * 特价
                     */
                    private Long discountPrice;
                    /**
                     * 享受特价数量
                     */
                    private Integer discountQty;
                    /**
                     * 优惠金额 正数
                     */
                    private Long discountAmount;
                    /**
                     * 活动子code
                     */
                    private String customerCode;
                    /**
                     * 活动自定义信息
                     */
                    private String addInfo;

                    private String productId;
                }

            }

            @NoArgsConstructor
            @Data
            public static class RefundBean {

                /**
                 * 订单ID
                 */
                private String orderId;

                /**
                 * 退款价格
                 */
                private Long price;

                /**
                 * 原因
                 */
                private String reason;

                /**
                 * 退款订单
                 */
                private String rid;

                /**
                 * 退款状态  1 申请退款 2 同意退款 3 已退货 4 退款完成 5 拒绝退款
                 */
                private Integer status;

                private String remark;
                //商家退单审核 备注
                private String decisionReason;

                //创建时间
                private String createTime;

            }

            @NoArgsConstructor
            @Data
            public static class AccountBean {
                /**
                 * accountId : 121347407098150912
                 * name : 满减折扣
                 * number : 1
                 * oaid :
                 * orderId : 119108155383846159
                 * price : -700
                 * sequence : 0
                 * type : 2
                 */
                private String accountId;
                private String name;
                private Integer number;
                private String oaid;
                /**
                 * 订单编号
                 */
                private String orderId;
                /**
                 * 优惠金额
                 */
                private Long price;

                // 实际金额
                private Long actualCostAmount;


                private Integer sequence;
                /**
                 * 结算对象类型  1 运费 2折扣 3包装费 4积分 5 优惠券 6线下支付 7 微信 8 支付宝 9 商户金额
                 */
                private Integer type;
                /**
                 * 自定义对象
                 */
                private String addInfo;
                //平台优惠
                private Long platformDiscountAmount;

                //商家优惠
                private Long shopDiscountAmount;
            }

            @NoArgsConstructor
            @Data
            public static class OperationHistory {
                private Long createTime;
                private String operationDesc;
                private String operationMethod;
                private String orderCode;
                private Integer operationType;
                private String partnerId;
                private String storeId;
                private Long updateTime;
                private Long updateTimestamp;
                private String operator;
            }

            @NoArgsConstructor
            @Data
            public static class OrderSettlement {

                // 订单商品ID
                private String productId;
                // 订单商品名称
                private String productName;
                // 商品序号
                private Integer productSeq;
                // 外部对象ID 如:活动ID
                private String externalObjectId;
                // 外部对象名称 如：活动名称
                private String externalObjectName;
                // 外部子对象
                private String externalObjectSubId;
                // 是否忽略，不参与优惠计算
                private Boolean ignoreInDiscountAmount;
                // 结算类型
                private Integer settlementType;
                // 结算类型名称
                private String settlementTypeName;
                // 结算金额
                private BigDecimal settlementAmount;
                // 备注
                private String note;
                // 优惠覆盖数量
                private Integer number;
                // 平台优惠
                private Long platformDiscountAmount;
                // 商家优惠
                private Long shopDiscountAmount;
                // 代理商优惠
                private Long agentDiscountAmount;
                // 承运商优惠
                private Long carrierDiscountAmount;
                // 商户实收总价
                private Long shopAmount;
                // 平台服务费
                private Long platformServiceAmount;
                // 商家预计收入
                private Long prospectiveAmount;
                // 是否线上 false:不是 true:是
                private Boolean isOnline;
                // 扩展字段
                private String extInfo;
            }

            @NoArgsConstructor
            @Data
            public static class OrderPayItem {
                private Long orderId;
                /**
                 * 订单号
                 */
                private String orderCode;
                private Integer payChannelType;
                private String payChannelName;
                /**
                 * 支付交易号
                 */
                private String orderPayItemCode;
                private BigDecimal payAmount;
            }
        }
    }
}
