package com.freemud.application.sdk.api.ordercenter.request.carpark;

import com.freemud.application.sdk.api.ordercenter.request.create.OrderSettlementCreateReq;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.*;

/**
 * 停车场
 * @author hongwang
 */
@Getter
@Setter
@ToString
public class ParkingOrderCreateReq {

    /*** "商户号"***/
    private String partnerId;

    /*** "门店编号"***/
    private String storeId;

    /*** "第三方订单号"***/
    private String thirdOrderCode;

    /*** "停车场ID"***/
    private String parkingAreaId;

    /*** "停车场名称"***/
    private String parkingAreaName;

    /*** "用户ID"***/
    private String userId;

    /*** "用户姓名"***/
    private String userName;

    /*** "订单金额"***/
    private BigDecimal originalAmount;

    /*** "实际支付现金金额，扣除支付自生优惠，单位分"***/
    private BigDecimal actualPayAmount;

    /*** "订单结算信息"***/
    List<OrderSettlementCreateReq> orderSettlementDetailList = new ArrayList<>();

    /*** "车牌号"***/
    private String carNumber;

    /*** "入场时间"***/
    private Date inTime;

    /*** "出场时间"***/
    private Date outTime;

    /*** "支付方式"***/
    private Byte PayChannelType;

    /*** "手机号"***/
    private String mobile;

    /*** "发票明细"***/
    private OrderInvoiceReq orderInvoice;

    /*** "默认不填=99，"+ OrderBizType.API_DESC***/
    private Byte bizType;

   
}
