package com.freemud.sdk.api.assortment.shoppingcart.service;

import cn.freemud.base.entity.BaseResponse;
import com.freemud.sdk.api.assortment.shoppingcart.domain.CollageMemberState;
import com.freemud.sdk.api.assortment.shoppingcart.domain.CollageOrder;
import com.freemud.sdk.api.assortment.shoppingcart.domain.CollageOrderDto;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0.0
 * @Description:
 * @author: hui.miao
 * @date: 2020-09-27 17:03
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public interface CollageOrderBaseService {
    /**
     * 查询拼单订单
     * @param collageOrderDto
     * @return
     */
    BaseResponse<CollageOrder> queryCollageOrder(CollageOrderDto collageOrderDto);

    /**
     * 创建拼单订单
     * @param collageOrderDto
     * @return
     */
    BaseResponse<CollageOrder> createCollageOrder(CollageOrderDto collageOrderDto);

    /**
     * 清除拼单订单Redis缓存
     * @param collageOrderDto
     * @return
     */
    BaseResponse clearCollageOrder(CollageOrderDto collageOrderDto);

    /**
     * 锁定拼单订单
     * @param collageOrderDto
     * @return
     */
    BaseResponse lockCollageOrder(CollageOrderDto collageOrderDto);

    /**
     * 解锁拼单订单
     * @param collageOrderDto
     * @return
     */
    BaseResponse unlockCollageOrder(CollageOrderDto collageOrderDto);

    /**
     * 获取拼单订单锁状态
     * @param collageOrderDto
     * @return
     */
    BaseResponse<Boolean> isLockedCollageOrder(CollageOrderDto collageOrderDto);

    /**
     * 获取加购人状态
     */
    BaseResponse<List<CollageMemberState>> getCollageMemberState(CollageOrderDto collageOrderDto);

    /**
     * 修改用户加购状态 加购完毕
     * @param collageOrderDto
     * @return
     */
    BaseResponse readyCollageMemberState(CollageOrderDto collageOrderDto);

    /**
     * 修改用户加购状态 继续选购
     * @param collageOrderDto
     * @return
     */
    BaseResponse shoppingCollageMemberState(CollageOrderDto collageOrderDto);

    /**
     * 设置用户的点餐位信息
     * @param collageOrderDto
     * @return
     */
    BaseResponse setCollageMember(CollageOrderDto collageOrderDto);


    /**
     * 设置用户在该店铺下的拼单时间
     * @param collageOrderDto
     * @return
     */
    BaseResponse setCollageMemberAddTime(CollageOrderDto collageOrderDto);

    /**
     * 判断用户是否参加了某一个拼单
     * @param collageOrderDto
     * @return
     */
    BaseResponse judgeMemberAddOneCollage(CollageOrderDto collageOrderDto);

    /**
     * 清除用户的点餐位
     * @param collageOrderDto
     * @return
     */
    BaseResponse cleanMemberSeat(CollageOrderDto collageOrderDto);

    /**
     * 获取用户的点餐中购物车行id
     */
    List<String> getMemCarLine(CollageOrderDto collageOrderDto);

    /**
     * 清除用户的购物车行
     */
    BaseResponse cleanMemberCartLine(CollageOrderDto collageOrderDto);

    /**
     * 清除用户选好了的状态
     */
    BaseResponse cleanMemberStates(CollageOrderDto collageOrderDto);

    /**
     * 清除用户在店铺下的拼单时间
     */
    BaseResponse cleanCollageMemberAddTime(CollageOrderDto collageOrderDto);
}
