package cn.freemud.service.impl.mcoffee.entity;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CouponAvailableReq
 * @Package cn.freemud.service.impl.mcoffee
 * @Description:
 * @author: ping1.wu
 * @date: 2020/8/4 16:10
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class CouponAvailableReq {

    //渠道id
    private String providerId;
    //商户号
    private String merchantId;
    private String city;
    private String storeId;

    //组织机构id列表（校验渠道限制）
    private List<String> channelIdList;

    //组织机构code列表（校验渠道限制）
    private List<String> channelCodeList;

    //券码列表
    private List<String> couponCodes;
    private Integer totalAmount;

    //核销渠道 枚举: mocoffee_wx : 麦咖啡微信小程序 mocoffee_zfb : 麦咖啡支付宝小程序
    private String redeemChannel;

    //购物车商品列表
    private List<CouponProductVo> productList;

    private String stationId;
    private String operatorId;

}
