/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetMemberCouponListRequestDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: song.cai
 * @date: 2018/12/24 16:49
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.entities.vo;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;

@Data
@NoArgsConstructor
public class GetAvailableStoresRequestVo {
    @NotNull
    private String sessionId;
    /**
     * 门店Id
     */
    @NotNull
    private String partnerId;
    /**
     * 优惠券code
     */
    @NotNull
    private String couponCode;
    /**
     * 小程序Id
     */
    @NotNull
    private String appId;

    /**
     * 纬度
     */
    @NotEmpty(message = "latitude不能为空")
    private String latitude;

    /**
     * 经度
     */
    @NotEmpty(message = "longitude不能为空")
    private String longitude;

    /**
     * 关键字查询（目前匹配门店名称、地址、标签等）
     */
    private String keyWords;
    /**
     * 距离（单位：km），不传默认查5公里以内
     */
    private String distance;

    /**
     * 页码 从 1 开始
     */
    private Integer pageNo;
    /**
     * 每页条目数
     */
    private Integer pageSize;

}
