/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderSourceType
 * @Package cn.freemud.enums
 * @Description:
 * @author: liming.guo
 * @date: 2018/6/1 21:40
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.order.enums;

import org.apache.commons.lang.StringUtils;

public enum OrderSourceType {
    WE_CHAT("we_chat", "自营微信小程序", 1),
    SAAS("saas", "saas 点餐", 2),
    ALIPAY("alipay", "支付宝", 3),
    HTML5("html5", "自营H5", 4),
    ANDROID("android", "自营安卓APP", 5),
    IOS("ios", "自营苹果APP", 6),
    PC_WEB("pcweb", "自营PC-WEB", 7),
    ELEME("eleme", "饿了么外卖", 8),
    EBAI("ebwm", "饿百外卖", 9),
    JDWM("jdwm", "京东到家", 10),
    MTWM("mtwm", "美团外卖", 11),
    APP("app", "APP", 12),
    I_MEMBER("imember", "i 会员订单", 13),
    I_CARGO("icargo", "i应用订货", 14),
    POS("pos", "线下 POS", 15),
    BDWM("bdwm", "百度外卖", 16),
    IPINTUAN("ipintuan", "i拼团", 18),
    MEAL("meal", "i围餐", 19),
    JUBAOPEN("jbp", "美团聚宝盆", 20),
    DIANPING("dp", "美团点评", 21),
    KOUBEI("koubeiwaimai", "口碑外卖", 22),
    MALL("mall", "非码Mall", 23),
    SAASMALL("saasmall", "微商城", 23),
    DPZHCT("dpzhct", "美团点评智慧餐厅", 24),
    FMWD("fmwd", "非码微店", 25),
    Y_POS("ypos", "非码云POS", 26),
    MTDP("mtdp", "美团点评", 27),
    parkingmanual("parkingmanual", "农工商停车手工录单", 98),
    PARKING("parking", "农工商停车", 99),
    SDG("sdg", "闪电购", 1000);

    private String code;
    private String desc;
    private Integer clientType;

    OrderSourceType(String code, String desc, Integer clientType) {
        this.code = code;
        this.desc = desc;
        this.clientType = clientType;
    }

    /**
     * 字符串渠道码转对应数字类型渠道码
     *
     * @param code
     * @return
     */
    static public Integer getClientByCode(String code) {
        Integer client = OrderSourceType.SAAS.getClientType();
        if (StringUtils.isBlank(code)) return client;
        for (OrderSourceType value : OrderSourceType.values()) {
            if (value.getCode().equals(code.toLowerCase())) {
                client = value.getClientType();
                break;
            }
        }
        return client;
    }

    /**
     * 数字类型渠道码转字符类型渠道码
     *
     * @param clientType
     * @return
     */
    static public String getCodeByClientType(Integer clientType) {
        String name = "";
        for (OrderSourceType value : OrderSourceType.values()) {
            if (value.getClientType().equals(clientType)) {
                name = value.getCode();
                break;
            }
        }
        if (StringUtils.isBlank(name)) name = clientType.toString();
        return name;
    }

    /**
     * 数字类型渠道码转字符类型渠道码注释
     *
     * @param clientType
     * @return
     */
    static public String getDescByClientType(Integer clientType) {
        String name = "";
        for (OrderSourceType value : OrderSourceType.values()) {
            if (value.getClientType().equals(clientType)) {
                name = value.getDesc();
                break;
            }
        }
        if (StringUtils.isBlank(name)) name = clientType.toString();
        return name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getClientType() {
        return clientType;
    }

    public void setClientType(Integer clientType) {
        this.clientType = clientType;
    }
}
