package cn.freemud.entities.dto.shoppingCart;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@NoArgsConstructor
@Data
public class GetShoppingCartGoodsApportionResponse {

 /**
  * code : 100
  * message : success
  * ver : 1
  * result : {"products":[{"spuId":"125765848166145819","skuId":"125767075371261726","spuName":"多规格商品","skuName":"多规格商品/规格值2.1/规格值1/规格值1.1","originalPrice":1,"picture":"https://picture.sandload.cn/1542723625765.jpg","qty":1,"hasProductCoupon":false,"activityType":null,"nodeId":"0101","categoryName":"分类1","extraList":[{"attributeId":"125609463668467994","attributeName":"加超多冰"},{"attributeId":"125610057277827381","attributeName":"七分甜"}],"attributeNames":"{\"attributeNames\":\"加超多冰/七分甜\"}"}],"originalTotalAmount":null,"totalAmount":null,"totalDiscountAmount":null,"packageAmount":0,"shareDiscountActivityDtos":[{"spuId":"125765848166145819","goodsId":"125767075371261726","originalPrice":1,"goodsQuantity":1,"hasProductCoupon":false,"activityType":null,"apportionGoods":[{"goodsId":"125767075371261726","goodsQuantity":1,"nowPrice":1,"originalPrice":1,"apportionAmount":0,"apportionDetails":[]}]}]}
  */
 private String code;
 private String message;
 private String ver;
 private ShoppingCartGoodsDto result;

 @NoArgsConstructor
 @Data
 public static class ResultBean {
  /**
   * products : [{"spuId":"125765848166145819","skuId":"125767075371261726","spuName":"多规格商品","skuName":"多规格商品/规格值2.1/规格值1/规格值1.1","originalPrice":1,"picture":"https://picture.sandload.cn/1542723625765.jpg","qty":1,"hasProductCoupon":false,"activityType":null,"nodeId":"0101","categoryName":"分类1","extraList":[{"attributeId":"125609463668467994","attributeName":"加超多冰"},{"attributeId":"125610057277827381","attributeName":"七分甜"}],"attributeNames":"{\"attributeNames\":\"加超多冰/七分甜\"}"}]
   * originalTotalAmount : null
   * totalAmount : null
   * totalDiscountAmount : null
   * packageAmount : 0
   * shareDiscountActivityDtos : [{"spuId":"125765848166145819","goodsId":"125767075371261726","originalPrice":1,"goodsQuantity":1,"hasProductCoupon":false,"activityType":null,"apportionGoods":[{"goodsId":"125767075371261726","goodsQuantity":1,"nowPrice":1,"originalPrice":1,"apportionAmount":0,"apportionDetails":[]}]}]
   */

  private Object originalTotalAmount;
  private Object totalAmount;
  private Object totalDiscountAmount;
  private int packageAmount;
  private List<ProductsBean> products;
  private List<ShareDiscountActivityDtosBean> shareDiscountActivityDtos;

  @NoArgsConstructor
  @Data
  public static class ProductsBean {
   /**
    * spuId : 125765848166145819
    * skuId : 125767075371261726
    * spuName : 多规格商品
    * skuName : 多规格商品/规格值2.1/规格值1/规格值1.1
    * originalPrice : 1
    * picture : https://picture.sandload.cn/1542723625765.jpg
    * qty : 1
    * hasProductCoupon : false
    * activityType : null
    * nodeId : 0101
    * categoryName : 分类1
    * extraList : [{"attributeId":"125609463668467994","attributeName":"加超多冰"},{"attributeId":"125610057277827381","attributeName":"七分甜"}]
    * attributeNames : {"attributeNames":"加超多冰/七分甜"}
    */

   private String spuId;
   private String skuId;
   private String spuName;
   private String skuName;
   private int originalPrice;
   private String picture;
   private int qty;
   private boolean hasProductCoupon;
   private Object activityType;
   private String nodeId;
   private String categoryName;
   private String attributeNames;
   private List<ExtraListBean> extraList;

   @NoArgsConstructor
   @Data
   public static class ExtraListBean {
    /**
     * attributeId : 125609463668467994
     * attributeName : 加超多冰
     */

    private String attributeId;
    private String attributeName;
   }
  }

  @NoArgsConstructor
  @Data
  public static class ShareDiscountActivityDtosBean {
   /**
    * spuId : 125765848166145819
    * goodsId : 125767075371261726
    * originalPrice : 1
    * goodsQuantity : 1
    * hasProductCoupon : false
    * activityType : null
    * apportionGoods : [{"goodsId":"125767075371261726","goodsQuantity":1,"nowPrice":1,"originalPrice":1,"apportionAmount":0,"apportionDetails":[]}]
    */

   private String spuId;
   private String goodsId;
   private int originalPrice;
   private int goodsQuantity;
   private boolean hasProductCoupon;
   private Object activityType;
   private List<ApportionGoodsBean> apportionGoods;

   @NoArgsConstructor
   @Data
   public static class ApportionGoodsBean {
    /**
     * goodsId : 125767075371261726
     * goodsQuantity : 1
     * nowPrice : 1
     * originalPrice : 1
     * apportionAmount : 0
     * apportionDetails : []
     */

    private String goodsId;
    private int goodsQuantity;
    private int nowPrice;
    private int originalPrice;
    private int apportionAmount;
    private List<?> apportionDetails;
   }
  }
 }
}
