package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.application.sdk.api.promotioncenter.request.promotion.ActivityUpdateStockRequest;
import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.mail.core
 * @Description: ${TODO}(用一句话描述该文件做什么)
 * @author: aiqi.gong
 * @date: 2019/7/18 18:43
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class AssortmentSdkUpdateOrderProductInfoRequest extends BaseConfig {
    /**
     * 非码订单编号
     */
    private String orderCode;
    /**
     * 第三方商品编号
     */
    private String thirdOrderCode;
    /**
     * 订单渠道
     */
    private Integer orderClient;
    private String partnerId;
    private String storeId;
    private OpUpdateOrderItemEnum opUpdateOrderItemEnum;

    /**
     * 就餐人数
     */
    private Integer dinersNumber;

    //实际支付现金金额，扣除支付自生优惠，单位分
    private Long actualPayAmount;

    //订单原始金额，单位分
    private Long originalAmount;

    //支付渠道
    private String payChannel;

    //支付渠道名称
    private String payChannelName;

    //当前支付请求号
    private String payRequestNo;

    //支付时间
    private String payTime;

    //支付类型 1:线上支付 2:线下支付
    private Integer payType;

    //用户在界面上看到的支付金额
    private Long settlementAmount;

    //用户ID
    private String userId;

    //用户姓名
    private String userName;


    /**
     * deleteAndUpdate 会先清除订单下面所有商品，然后再插入商品
     * update 表示只会更新商品，会合并相同的商品
     * updateByOrderProductDetailId 只会根据订单商品ID更新商品信息不会进行任何合并
     * deleteOrderProduct 删除订单商品
     * updatePrePayPriceTwo 已经唤起过支付，不在进行促销计算和扣减库存
     */
    public enum OpUpdateOrderItemEnum{
        deleteAndUpdate,update,updateByOrderProductDetailId,updatePrePayPrice,deleteOrderProduct,updatePrePayPriceTwo
    }
    private List<CreateOrderProductRequest> orderItemList;

    //操作人
    private String operator;

    /**
     * 消息Queue信息
     */
    MqMessageRequest mqMessageRequest;

    /**
     * 其他结算列表
     */
    private List<CreateOrderAccountRequest> accounts;

    /**
     * 促销活动扣减库存
     */
    public ActivityUpdateStockRequest activityUpdateStockRequest;

    private String menuType ;

    /**
     * 是否更新结算信息
     */
    private boolean updateAccounts;
}
