package cn.freemud.service.impl;

import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.utils.ValidationCode;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class MallOrderServiceImplTest {

    @Autowired
    private MallOrderServiceImpl mallOrderService;

    @Autowired
    private MCCafeOrderServiceImpl mcCafeOrderService;

    @Autowired
    private OrderServiceImpl orderService;


    @Before
    public void before() throws Exception {
    }

    @After
    public void after() throws Exception {
    }

    @Test
    public void f1() {
        mcCafeOrderService.createOrder(JSON.parseObject("{\"channelType\":\"saas\",\"couponCode\":\"\",\"menuType\":\"saasdelivery\",\"needInvoice\":0,\"needTableware\":0,\"orderRemark\":\"\",\"orderType\":2,\"partnerId\":\"1206\",\"payChannelType\":1,\"receiveId\":\"3599568180562003060\",\"sessionId\":\"c4377678dbcbd6cdf6e7df86ea112b6f82723023\",\"shopId\":\"1450026\",\"takeMealFlag\":\"0\"}", CreateOrderVo.class),
                new StoreResponse.BizVO(),
                JSON.parseObject("{\"activityDiscountsDtos\":[],\"deliveryAmount\":10,\"discountDeliveryAmount\":10,\"isDiscountDelivery\":false,\"originalTotalAmount\":4400,\"packageAmount\":0,\"products\":[{\"activityDiscountsDtos\":[],\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"cartGoodsUid\":\"eb8c7260-8ecb-44d1-9234-8d8bed0b0875\",\"classificationId\":\"\",\"classificationName\":\"\",\"comboProducts\":[{\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"customerCode\":\"501642\",\"extraList\":[],\"hasProductCoupon\":false,\"isFixedProduct\":false,\"materialList\":[],\"originalPrice\":1700,\"parentProductId\":\"184437853099519288\",\"picture\":\"https://picture.sandload.cn/1598678546485.png\",\"productType\":6,\"qty\":2,\"skuId\":\"184437494035639613\",\"skuName\":\"中杯热美式\",\"spuId\":\"184437494035639613\",\"spuName\":\"中杯热美式\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0},{\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"customerCode\":\"901290\",\"extraList\":[],\"hasProductCoupon\":false,\"isFixedProduct\":false,\"materialList\":[],\"originalPrice\":500,\"parentProductId\":\"184437853099519288\",\"picture\":\"https://picture.sandload.cn/1598677404074.png\",\"productType\":6,\"qty\":2,\"skuId\":\"184436294373469463\",\"skuName\":\"经典芝士蛋糕\",\"spuId\":\"184436294373469463\",\"spuName\":\"经典芝士蛋糕\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0}],\"customerCode\":\"901280\",\"extraList\":[],\"hasProductCoupon\":false,\"materialList\":[],\"originalPrice\":4400,\"picture\":\"https://picture.sandload.cn/1598678861518.png\",\"productCode\":\"901280\",\"productType\":6,\"qty\":2,\"salePrice\":4400,\"skuId\":\"184437853099519288\",\"skuName\":\"早餐啡常搭\",\"spuId\":\"184437853099519288\",\"spuName\":\"早餐啡常搭\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0}],\"shareDiscountActivityDtos\":[],\"totalAmount\":4400,\"totalDiscountAmount\":0}", ShoppingCartGoodsDto.class),
                new OrderExtendedReq(),
                OrderClientType.SAAS,"www");
    }

    @Test
    public void f2() {
        mcCafeOrderService.mcCafePaySuccessCallback(JSON.parseObject("{\"endTransId\":\"4200000731202010272812645480\",\"merchantCoupon\":0,\"openId\":\"oDF-Z5aYxM8xBKAzCeYCcdAIByT4\",\"partnerId\":\"1205\",\"platformCoupon\":0,\"platformMchId\":\"1259889901\",\"resultCode\":\"100\",\"thirdPartTradeNo\":\"4200000731202010272812645480\",\"totalAmount\":3800,\"tradeTime\":\"20201027170829\",\"transCurrency\":\"CNY\",\"transId\":\"19267384897250820300001\",\"transactionCode\":\"TSXA1205O230012700873498624\"}"
                , NewPaysuccessNoticeMessage.class));
    }

    @Test
    public void f3() {
        orderService.mcCafeQueryOrderById(JSON.parseObject("{\"channelType\":\"saas\",\"partnerId\":\"1206\",\"appId\":\"wx6816a0b007741702\",\"sessionId\":\"07e359b4147ef0182951b2c064f5ec8d716a702a\",\"orderType\":1,\"menuType\":\"saas\",\"shopId\":\"1450026\",\"oid\":\"19284932547021936900006\"}", MaCafeQueryOrderVo.class));
    }

    @Test
    public void testPaySuccess() {
        //0元支付
        String fmId = "SPAY" + ValidationCode.getRandomUuid();
        PaysuccessNoticeMessage message = new PaysuccessNoticeMessage();
        message.setResult_code(100);
        message.setOut_trade_no(fmId);
        message.setTrans_id("16303606485084241800003");
        message.setTotal_fee(0);
        message.setOpenid("oORZK5MHMBm78PO302NdRyzIY5K0");
        message.setPlatform_coupon(0);
        message.setMerchant_coupon(0);
        mallOrderService.paySuccessCallback(message);
    }

    @Test
    public void testAffirm() {
        OrderAffirmRequestVO requestVO = new OrderAffirmRequestVO();
        requestVO.setPartnerId("1864");
        requestVO.setShopId("8899");
        requestVO.setSessionId("123123");
        requestVO.setChannelType("saasmall");
        requestVO.setOid("16303606485084241800003");
        mallOrderService.orderAffirm(requestVO);
    }
}
