package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/5/19 下午2:29
 * @description : 老门店商品 替换到 新门店商品下的 vo对象
 */
@Data
public class ShopGoodsReplaceVo extends BaseRequestVo {
    /**
     * 微信appId
     */
    @NotEmpty(message = "appId不能为空")
    private String appId;

    /**
     * 购买类型 0=普通购买 1=立即购买 ，默认值为普通购买
     */
//    @ApiModelProperty(value = "购买类型 0=普通购买 1=立即购买 ，默认值为普通购买")
//    private int buyType = 0;

    /**
     * 业务类型： 0 : 自提 1：外卖 2：微商城
     */
    private String menuType ;

    // 我需要的字段----------
    @NotEmpty(message = "oldShopId不能为空")
    private String oldShopId;

    /**
     * 收货地址ID、svc卡支付外卖订单必传
     */
    private String receiveId;

    // 测试的时候 使用
    private Integer hook;
}
