package com.freemud.sdk.api.assortment.shoppingcart.domain;

import lombok.Builder;
import lombok.Data;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0.0
 * @Description:
 * @author: hui.miao
 * @date: 2020-09-27 17:11
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Builder
@Data
public class CollageOrder
{
    /**
     * 拼单订单ID
     */
    private String collageId;

    /**
     * 拼单邀请者用户ID
     */
    private String createCollageUserId;

    /**
     * 商户ID
     */
    private String partnerId;

    /**
     * 商户名称
     */
    private String partnerName;

    /**
     * 门店ID
     */
    private String storeId;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 创建时间
     */
    private Long createTime;

    /**
     * 过期时间
     */
    private Long expireTime;

    /**
     * 拼单的订单编号（调用创单接口后回写更新）
     */
    private String orderCode;

    /**
     * 拼单状态 0 拼单中；1 已完成；2 已取消
     */
    private Integer status;
}
