package cn.freemud.entities.dto;

import lombok.Data;

import java.awt.geom.Point2D;
import java.util.Date;
import java.util.List;

@Data
public class StoreDeliveryInfoDto {

    private String partnerId;

    private String storeId;

    private String storeName;
    /**
     * 门店是否可配送
     */
    private Boolean enableTakeaway;
    /**
     * 起送费单位分
     */
    private Long deliveryLimitAmount;
    /**
     * 基础配送费，单位分
     */
    private Long deliveryAmount;
    /**
     *  默认配送公里数 单位 m
     */
    private Long defaultDeliveryRange;
    /**
     * 每增加多少公里 单位米
     */
    private Long addRangeCount;
    /**
     * 增加多少元 单位分
     */
    private Long addRangeAmount;
    /**
     *  当天配送时间 10:00-22:00
     */
    private String deliveryHoursDay;
    /**
     * 当天配送开始时间
     */
    private Date deliveryStartTime;

    /**
     * 当天配送结束时间
     */
    private Date deliveryEndTime;
    /**
     * 门店经度
     */
    private String longitude;
    /**
     * 门店维度
     */
    private String latitude;
    /**
     * 门店配送范围集合
     */
    private List<Point2D.Double> point2DList;
    /**
     * 配送范围绘制{1：自定义；2：按半径},默认为1
     */
    private String scopeConfig;
    /**
     * 配送半径,整型，单位米
     */
    private Integer deliveryRadius;

    /**
     * 第三方外卖类型
     */
    private String deliveryType;

    /**
     * 预订单自定义推单时间
     */
    private Integer pushOrderTime;

}
