package cn.freemud.entities.vo.coupon;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: QueryCartInfoRequestVo
 * @Package cn.freemud.entities.vo
 * @Description: 简单描述下这个类是做什么用的
 * @author: yu.sun
 * @date: 2020/9/11 10:35
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class CouponAvailableRequestVo {

    @NotNull(message = "门店id不可为空")
    private String storeId;

    @ApiModelProperty(value = "sessionId",required = true)
    @NotNull(message = "用户sessionId不可为空")
    private String sessionId;

    @ApiModelProperty(value = "menuType",notes = "菜单类型 saas(开个店自提)、saasdelivery（开个店外卖）",required = true)
    @NotNull(message ="菜单类型不可为空")
    private String menuType ;

    @ApiModelProperty(value = "订单类型 1到店自取 2外卖")
    @NotNull(message = "订单类型不可为空")
    private Integer orderType;

    @ApiModelProperty(value = "收货地址id",notes = "svc卡支付外卖订单必传")
    private String receiveId;
}