package cn.freemud.service.impl;

import ch.qos.logback.classic.Level;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.ShoppingCartGoodsBaseResponseVo;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.utils.LogUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.base.SDKCommonBaseContextWare;
import com.freemud.application.sdk.api.log.ErrorLog;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import com.freemud.sdk.api.assortment.shoppingcart.enums.BusinessTypeEnum;
import com.freemud.sdk.api.assortment.shoppingcart.request.CheckCartRequest;
import com.freemud.sdk.api.assortment.shoppingcart.request.GetProductInfoRequest;
import com.freemud.sdk.api.assortment.shoppingcart.service.ShoppingCartBaseService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.naming.Name;
import java.util.ArrayList;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: AssortmentSdkService
 * @Package cn.freemud.service.impl
 * @Description:
 * @author: jiaxin.liu
 * @date: 2019/4/20 15:20
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class AssortmentSdkService {

    /**
     * 调用聚合sdk获取单个商品行信息
     *
     * @param partnerId
     * @param userId
     * @param storeId
     * @param cartGoodsUid
     * @return
     */
    public CartGoods getCartGoodsBySdk(String partnerId, String userId, String storeId, String cartGoodsUid, String tableNumber, ShoppingCartBaseService shoppingCartService) {
        com.freemud.sdk.api.assortment.shoppingcart.domain.CartParamDto cartParamDto = getCartParamDto(partnerId, storeId, userId);
        cartParamDto.setCartGoodsUid(cartGoodsUid);
        cartParamDto.setTableNumber(tableNumber);
        BaseResponse<com.freemud.sdk.api.assortment.shoppingcart.domain.CartGoods> baseResponse = shoppingCartService.getCartGoods(cartParamDto, LogThreadLocal.getTrackingNo());
        if (baseResponse == null || !ResponseResult.SUCCESS.getCode().equals(baseResponse.getCode()) || baseResponse.getResult() == null) {
            ErrorLog.printLog(SDKCommonBaseContextWare.getAppName(), LogThreadLocal.getTrackingNo(), getClass(), "getCartGoods:" + JSONObject.toJSONString(baseResponse), cartParamDto, Level.ERROR);
            return null;
        }

        return JSONObject.parseObject(JSONObject.toJSONString(baseResponse.getResult()),CartGoods.class);
    }

    /**
     * 调用聚合sdk更新商品行数量信息
     *
     * @param partnerId
     * @param userId
     * @param storeId
     * @param cartGoodsUid
     * @param qty
     * @return
     */
    public List<CartGoods> updateGoodsQtyBySdk(String partnerId, String userId, String storeId, String cartGoodsUid, Integer qty, String tableNumber, ShoppingCartBaseService shoppingCartService) {
        com.freemud.sdk.api.assortment.shoppingcart.domain.CartParamDto cartParamDto = getCartParamDto(partnerId, storeId, userId);
        cartParamDto.setCartGoodsUid(cartGoodsUid);
        cartParamDto.setQty(qty);
        cartParamDto.setTableNumber(tableNumber);
        BaseResponse<List<com.freemud.sdk.api.assortment.shoppingcart.domain.CartGoods>> baseResponse = shoppingCartService.updateGoodsQty(cartParamDto, LogThreadLocal.getTrackingNo());
        if (baseResponse == null || !ResponseResult.SUCCESS.getCode().equals(baseResponse.getCode())) {
            return null;
        }

        return JSONArray.parseArray(JSONObject.toJSONString(baseResponse.getResult()), CartGoods.class);
    }

    /**
     * 调用聚合sdk获取缓存中购物车信息
     *
     * @param partnerId
     * @param storeId
     * @param useId
     * @return
     */
    public List<CartGoods> getShoppingCart(String partnerId, String storeId, String useId, String sessionId, String tableNumber, ShoppingCartBaseService shoppingCartService) {
        com.freemud.sdk.api.assortment.shoppingcart.domain.CartParamDto cartParamDto = getCartParamDto(partnerId, storeId, useId);
        cartParamDto.setSessionId(sessionId);
        cartParamDto.setTableNumber(tableNumber);
        // 根据不同点餐类型获取不同购物车实例
        BaseResponse<List<com.freemud.sdk.api.assortment.shoppingcart.domain.CartGoods>> baseResponse = shoppingCartService.getCartGoodsList(cartParamDto, LogThreadLocal.getTrackingNo());
        if (baseResponse == null || !ResponseResult.SUCCESS.getCode().equals(baseResponse.getCode()) || CollectionUtils.isEmpty(baseResponse.getResult())) {
            return new ArrayList<>();
        }

        return JSONArray.parseArray(JSONObject.toJSONString(baseResponse.getResult()), CartGoods.class);
    }

    /**
     * 调用聚合sdk获取缓存中购物车信息
     *
     * @param partnerId
     * @param storeId
     * @param useId
     * @return
     */
    public List<CartGoods> getShoppingCartForCoupon(String partnerId, String storeId, String useId, String tableNumber, ShoppingCartBaseService shoppingCartService) {
        com.freemud.sdk.api.assortment.shoppingcart.domain.CartParamDto cartParamDto = getCartParamDto(partnerId, storeId, useId);
        cartParamDto.setTableNumber(tableNumber);
        // 根据不同点餐类型获取不同购物车实例
        BaseResponse<List<com.freemud.sdk.api.assortment.shoppingcart.domain.CartGoods>> baseResponse = shoppingCartService.getCartGoodsList(cartParamDto, LogThreadLocal.getTrackingNo());
        if (baseResponse == null || !ResponseResult.SUCCESS.getCode().equals(baseResponse.getCode()) || CollectionUtils.isEmpty(baseResponse.getResult())) {
            return new ArrayList<>();
        }

        return JSONArray.parseArray(JSONObject.toJSONString(baseResponse.getResult()), CartGoods.class);
    }

    /**
     * 调用聚合sdk获取缓存中购物车代金券信息
     *
     * @param partnerId
     * @param storeId
     * @param useId
     * @return
     */
    public String getShoppingCartCoupon(String partnerId, String storeId, String useId, ShoppingCartBaseService shoppingCartService) {
        com.freemud.sdk.api.assortment.shoppingcart.domain.CartParamDto cartParamDto = getCartParamDto(partnerId, storeId, useId);

        BaseResponse<String> baseResponse = shoppingCartService.getCartCouponCode(cartParamDto, LogThreadLocal.getTrackingNo());
        if (baseResponse == null || !ResponseResult.SUCCESS.getCode().equals(baseResponse.getCode()) || StringUtils.isEmpty(baseResponse.getResult())) {
            return "";
        }

        return baseResponse.getResult();
    }

    /**
     * 调用聚合sdk设置缓存中购物车信息
     *
     * @param partnerId
     * @param storeId
     * @param useId
     * @return
     */
    public List<CartGoods> setShoppingCart(String partnerId, String storeId, String useId, List<CartGoods> cartGoodsList, String sessionId, String tableNumber, ShoppingCartBaseService shoppingCartService) {
        com.freemud.sdk.api.assortment.shoppingcart.domain.CartParamDto cartParamDto = getCartParamDto(partnerId, storeId, useId);
        cartParamDto.setSessionId(sessionId);
        cartParamDto.setTableNumber(tableNumber);
        cartParamDto.setCartGoodsList(JSONArray.parseArray(JSONObject.toJSONString(cartGoodsList), com.freemud.sdk.api.assortment.shoppingcart.domain.CartGoods.class));
        BaseResponse<List<com.freemud.sdk.api.assortment.shoppingcart.domain.CartGoods>> baseResponse = shoppingCartService.setCartGoodsList(cartParamDto, LogThreadLocal.getTrackingNo());
        if (baseResponse == null || !ResponseResult.SUCCESS.getCode().equals(baseResponse.getCode())) {
            return null;
        }

        return JSONArray.parseArray(JSONObject.toJSONString(baseResponse.getResult()), CartGoods.class);
    }

    /**
     * 调用聚合sdk设置缓存中购物车代金券
     *
     * @param partnerId
     * @param storeId
     * @param useId
     * @return
     */
    public List<CartGoods> setShoppingCartCouponCode(String partnerId, String storeId, String useId, String couponCode, ShoppingCartBaseService shoppingCartService) {
        com.freemud.sdk.api.assortment.shoppingcart.domain.CartParamDto cartParamDto = getCartParamDto(partnerId, storeId, useId);
        cartParamDto.setCouponCode(couponCode);
        BaseResponse<String> baseResponse = shoppingCartService.setCartCouponCode(cartParamDto, LogThreadLocal.getTrackingNo());
        if (baseResponse == null || !ResponseResult.SUCCESS.getCode().equals(baseResponse.getCode())) {
            return null;
        }

        return JSONArray.parseArray(JSONObject.toJSONString(baseResponse.getResult()), CartGoods.class);
    }

    /**
     * 调用SDK校验购物车
     *
     * @param oldAllCartGoodsList
     * @param partnerId
     * @param storeId
     * @param shoppingCartGoodsResponseVo
     * @param orderType
     */
    public CheckCartRequest checkShoppingCartSdk(List<CartGoods> oldAllCartGoodsList, String partnerId, String storeId, ShoppingCartGoodsBaseResponseVo shoppingCartGoodsResponseVo
            , Integer orderType, String tableNumber, String menuType ,ShoppingCartBaseService shoppingCartService) {
        CheckCartRequest checkCartRequest = new CheckCartRequest();
        checkCartRequest.setCartGoodsList(JSONArray.parseArray(JSONObject.toJSONString(oldAllCartGoodsList), com.freemud.sdk.api.assortment.shoppingcart.domain.CartGoods.class));
        checkCartRequest.setOrderWay(orderType);
        checkCartRequest.setPartnerId(partnerId);
        checkCartRequest.setShoppingCartGoodsResponseVo(JSONObject.parseObject(JSONObject.toJSONString(shoppingCartGoodsResponseVo), com.freemud.sdk.api.assortment.shoppingcart.domain.ShoppingCartGoodsResponseVo.class));
        checkCartRequest.setStoreId(storeId);
        checkCartRequest.setTableNumber(tableNumber);
        checkCartRequest.setTrackingNo(LogThreadLocal.getTrackingNo());
        checkCartRequest.setMenuType(BusinessTypeEnum.getByType(menuType).getCode());
        BaseResponse<CheckCartRequest> baseResponse ;
        baseResponse= shoppingCartService.checkAllCartGoodsNew(checkCartRequest);
        if (baseResponse == null) {
            return null;
        }
        return baseResponse.getResult();
    }

    /**
     * 调用SDK获取商品详情
     *
     * @param partnerId
     * @param storeId
     * @param goodsIds
     * @return
     */
    public List<ProductBeanDTO> getProductsInfoSdk(String partnerId, String storeId, List<String> goodsIds,String menuType, ShoppingCartBaseService shoppingCartService) {
        GetProductInfoRequest request = new GetProductInfoRequest();
        request.setGoodsIds(goodsIds);
        request.setPartnerId(partnerId);
        request.setStoreId(storeId);
        request.setTrackingNo(LogThreadLocal.getTrackingNo());
        request.setMenuType(BusinessTypeEnum.getByType(menuType).getCode());
        BaseResponse<List<ProductBeanDTO>> baseResponse =
                shoppingCartService.getProductsInfo(request);
        if (baseResponse == null || !ResponseResult.SUCCESS.getCode().equals(baseResponse.getCode()) || CollectionUtils.isEmpty(baseResponse.getResult())) {
            throw new ServiceException(ResponseResult.SHOPPING_CART_PRODUCT_NOT_EXIST);
        }
        return baseResponse.getResult();
    }

    /**
     * 组装CartParamDto信息
     *
     * @param partnerId
     * @param storeId
     * @param useId
     * @return
     */
    public com.freemud.sdk.api.assortment.shoppingcart.domain.CartParamDto getCartParamDto(String partnerId, String storeId, String useId) {
        com.freemud.sdk.api.assortment.shoppingcart.domain.CartParamDto cartParamDto = new com.freemud.sdk.api.assortment.shoppingcart.domain.CartParamDto();
        cartParamDto.setPartnerId(partnerId);
        cartParamDto.setUserId(useId);
        cartParamDto.setStoreId(storeId);
        return cartParamDto;
    }
}
