package cn.freemud.service.universal.impl;

import cn.freemud.entities.bo.CreateOrderBo;
import cn.freemud.entities.vo.CreateOrderBaseVo;
import cn.freemud.entities.vo.CreateOrderSaasVo;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.universal.UniversalOrderService;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.springframework.stereotype.Service;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import java.util.Iterator;
import java.util.Set;

@Service
public class SaasOrderService extends UniversalOrderService {

    @Override
    public void getCustomCreateOrderBo(CreateOrderBo createOrderBo) {

    }

    @Override
    public void validParam(CreateOrderBaseVo createOrderBaseVo) {
        CreateOrderSaasVo createOrderSaasVo = (CreateOrderSaasVo) createOrderBaseVo;
        // 利用 HibernateValidator 校验  标签参数是否满足
        HibernateValidatorConfiguration configuration = Validation.byProvider(HibernateValidator.class)
                .configure()
                .failFast(false);
        ValidatorFactory validatorFactory = configuration.buildValidatorFactory();
        Set<ConstraintViolation<CreateOrderBaseVo>> set = validatorFactory.getValidator().validate(createOrderSaasVo);
        if(CollectionUtils.isNotEmpty(set)) {
            Iterator<ConstraintViolation<CreateOrderBaseVo>> iterator = set.iterator();
            if (iterator.hasNext()) {
                ConstraintViolation<CreateOrderBaseVo> constraintViolation = iterator.next();
                throw new ServiceException(ResponseResult.PARAMETER_MISSING, constraintViolation.getMessage());
            }
        }
    }

    @Override
    public void getExtInfoCustom(CreateOrderBo createOrderBo) {

    }
}
