package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.MemberInfoDto;
import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.vo.*;
import cn.freemud.service.impl.StoreServiceImpl;
import cn.freemud.service.impl.UserServiceImpl;
import cn.freemud.service.thirdparty.WeChatClient;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Map;
import java.util.Objects;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;

/**
 * @author liming.guo
 * @date 2018/5/11
 * @description
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class UserServiceTest {

    @Autowired
    private UserServiceImpl userService;
    @Autowired
    private WeChatClient weChatClient;
    @Autowired
    private StoreServiceImpl storeService;

    @Test
    public void getUserInfo() {
        MemberInfoDto memberInfoDto = userService.getUserInfo("ob0iP4gZeV0jWtRWxRmGtBuE0M9k", "360bb48b-5316-458a-903e-9a44c7f339b1","17621508590");
        System.out.println("userInfo===" + memberInfoDto);
    }

    @Test
    public void userRegister() {
        String str = userService.registerMember("wx1232133432", "wx1232133432", "360bb48b-5316-458a-903e-9a44c7f339b1").getMemberId();
        System.out.println("str===="+str);
    }

    @Test
    public void sendSmsCode() {
        SendSmsCodeVo sendSmsCodeVo = new SendSmsCodeVo();
        sendSmsCodeVo.setSessionId("30971a41d753e62714edab501e9246ed9bfcef0a");
        sendSmsCodeVo.setMobile("15170070314");
        BaseResponse baseResponse = userService.sendSmsCode(sendSmsCodeVo);
        System.out.println("str====" + baseResponse);
    }

    @Test
    public void editMobile() {
        EditMobileVo editMobileVo = new EditMobileVo();
        editMobileVo.setMobile("13170070314");
        editMobileVo.setSmsCode("123456");
        editMobileVo.setSessionId("21321234324");
        BaseResponse baseResponse = userService.editMobile(editMobileVo);
        System.out.println("str====" + baseResponse);
    }

    @Test
    public void getSessionTest() {
        String appid = "wx17747e8875943c8a";
        String secret = "9b8c257bcf5fcba3dc244e44b4b504dc";
        String jsCode = "011KDpYO1dOXc216tK0P1WnGYO1KDpY8";
        String grantType = "authorization_code";
        String responseMessage = weChatClient.getSession(appid, secret, jsCode, grantType);
        System.out.println("str==" + responseMessage);
    }

    @Test
    public void getSessionId() {
        GetUserLoginSessionIdVo getUserLoginSessionIdVo = new GetUserLoginSessionIdVo();
        getUserLoginSessionIdVo.setCode("1243122142421442");//openid
        getUserLoginSessionIdVo.setPartnerId("1864");
        getUserLoginSessionIdVo.setAppId("wx12312321");
        getUserLoginSessionIdVo.setVersion("1");
        BaseResponse<UserLoginVo> baseResponse = userService.getSessionId(getUserLoginSessionIdVo);
        assertEquals(baseResponse.getCode(), "100");
    }

    @Test
    public void getPhoneNumber() {
        GetPhoneNumberVo getPhoneNumberVo = new GetPhoneNumberVo();
        getPhoneNumberVo.setSessionId("5d5f5d86d14df5b8a0e05b44e6239f39649daddd");
        getPhoneNumberVo.setEncryptedData("ewrezc");
        getPhoneNumberVo.setIv("ivd");
        BaseResponse baseResponse = userService.getPhoneNumber(getPhoneNumberVo);
        assertEquals(baseResponse.getCode(), "100");
    }

    @Test
    public void registerByMobile() {
        RegisterByMobileVo registerByMobileVo = new RegisterByMobileVo();
        registerByMobileVo.setSessionId("5d5f5d86d14df5b8a0e05b44e6239f39649daddd");
        registerByMobileVo.setMobile("13000000000");
        registerByMobileVo.setSmsCode("213121");
        BaseResponse baseResponse = userService.registerByMobile(registerByMobileVo);
        assertEquals(baseResponse.getCode(), "100");
    }

    @Test
    public void getDeliveryAddress() {
        QueryDeliveryAddressVo queryDeliveryAddressVo = new QueryDeliveryAddressVo();
        queryDeliveryAddressVo.setSessionId("5d5f5d86d14df5b8a0e05b44e6239f39649daddd");
        queryDeliveryAddressVo.setLongitude("121.123124");
        queryDeliveryAddressVo.setLatitude("32.12312");
        queryDeliveryAddressVo.setPageNo(1);
        queryDeliveryAddressVo.setPageSize(5);
        queryDeliveryAddressVo.setShopId("1011");
        BaseResponse baseResponse = userService.getDeliveryAddress(queryDeliveryAddressVo);
        assertEquals(baseResponse.getCode(), "100");
    }

    @Test
    public void addDeliveryAddress() {
        AddDeliveryAddressVo addDeliveryAddressVo = new AddDeliveryAddressVo();
        addDeliveryAddressVo.setSessionId("5d5f5d86d14df5b8a0e05b44e6239f39649daddd");
        addDeliveryAddressVo.setReceiveId("123");
        addDeliveryAddressVo.setOfficeName("公司");
        addDeliveryAddressVo.setReceiveAddress("地址");
        addDeliveryAddressVo.setReceiveUsername("收货人");
        addDeliveryAddressVo.setReceiveMobile("13000000000");
        addDeliveryAddressVo.setSex(1);
        addDeliveryAddressVo.setLatitude("32.124214");
        addDeliveryAddressVo.setLongitude("121.123123231");
        addDeliveryAddressVo.setLabel("标签");
        BaseResponse baseResponse = userService.addDeliveryAddress(addDeliveryAddressVo);
        assertEquals(baseResponse.getCode(), "100");
    }

    @Test
    public void deleteDeliveryAddress() {
        DeleteDeliveryAddressVo deleteDeliveryAddressVo = new DeleteDeliveryAddressVo();
        deleteDeliveryAddressVo.setSessionId("5d5f5d86d14df5b8a0e05b44e6239f39649daddd");
        deleteDeliveryAddressVo.setReceiveId("1");
        BaseResponse baseResponse = userService.deleteDeliveryAddress(deleteDeliveryAddressVo);
        assertEquals(baseResponse.getCode(), "100");
    }

    @Test
    public void registerByUnionId() {
        RegisterByUnionIdRequestVo registerByUnionIdRequestVo = new RegisterByUnionIdRequestVo();
        registerByUnionIdRequestVo.setEncryptedData("ev=123");
        registerByUnionIdRequestVo.setIv("iv");
        registerByUnionIdRequestVo.setSessionId("5d5f5d86d14df5b8a0e05b44e6239f39649daddd");
        registerByUnionIdRequestVo.setPartnerId("1864");
        registerByUnionIdRequestVo.setAppId("wx321321323");
        BaseResponse<RegisterByUnionIdResponseVo> baseResponse = userService.registerByUnionId(registerByUnionIdRequestVo);
        assertEquals(baseResponse.getCode(), "100");
    }

    @Test
    public void getUserInfoMapBySessionId() {
        Map<String, Object> maps = userService.getUserInfoMapBySessionId("5d5f5d86d14df5b8a0e05b44e6239f39649daddd");
        assertFalse(maps.isEmpty());
    }

    @Test
    public void getUserLoginInfoBySessionId() {
        UserLoginInfoDto userLoginInfoDto = userService.getUserLoginInfoBySessionId("5d5f5d86d14df5b8a0e05b44e6239f39649daddd");
        assertFalse(Objects.equals(userLoginInfoDto, null));
    }

}
