package cn.freemud.service.impl;

import cn.freemud.entities.db.OpenPlatformIappWxappConfig;
import cn.freemud.entities.db.OpenPlatformWxapp;
import cn.freemud.entities.dto.RecommendProductRequestDto;
import cn.freemud.entities.dto.RecommendProductResponseDto;
import cn.freemud.entities.vo.TxProductRecommendRequestVo;
import cn.freemud.manager.OpenPlatformIappWxappConfigManager;
import cn.freemud.manager.OpenPlatformWxappManager;
import cn.freemud.redis.RedisCache;
import cn.freemud.service.RecommendService;
import cn.freemud.service.thirdparty.RecommendClient;
import cn.freemud.utils.LogUtil;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: RecommendServiceImpl
 * @Package cn.freemud.service.impl
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/9/28 20:10
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Slf4j
@Service
public class RecommendServiceImpl implements RecommendService {
    @Value("${saas.wx.service.provider.appid}")
    private String appId;
    @Value("${saas.wx.service.provider.mchid}")
    private String mchId;
    @Value("${saas.wx.service.provider.signkey}")
    private String signKey;
    @Autowired
    private RecommendClient recommendClient;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private OpenPlatformWxappManager openPlatformWxappManager;
    @Autowired
    private OpenPlatformIappWxappConfigManager openPlatformIappWxappConfigManager;
    private final Gson gson = new Gson();
    @Override
    public RecommendProductResponseDto txProductRecommend(TxProductRecommendRequestVo requestVo) {
        try {
            RecommendProductResponseDto responseDto = new RecommendProductResponseDto();
            String sessionId = requestVo.getSessionId();
            String storeId = requestVo.getStoreId();
            String redisKey = "saas:user:info:sessionId:" + sessionId;
            Map<String, Object> map = redisCache.getValue(redisKey);
            String openId = (String) map.get("openid");
            String wxAppid = (String) map.get("wxAppid");
            OpenPlatformWxapp wxapp = openPlatformWxappManager.findByWxappId(wxAppid);
            OpenPlatformIappWxappConfig wxappConfig = openPlatformIappWxappConfigManager.selectIappWxappConfigByWxAppId(wxAppid);
            responseDto.setGuessLikeName(wxappConfig.getGuessLikeName());
            responseDto.setGuessLikeNum(wxappConfig.getGuessLikeNum());
            String guessLikeStatus = null != wxappConfig && null != wxappConfig.getGuessLikeStatus() ? wxappConfig.getGuessLikeStatus() : "2";
            responseDto.setGuessLikeStatus(guessLikeStatus);
            if ("2".equals(guessLikeStatus)) {
                return responseDto;
            }
            String redisTxKey = "saas:user:info:cnxh:"+wxapp.getPartnerId()+"_"+storeId+"_"+ map.get("memberId");
            Map<String, Object> txMap = redisCache.getValue(redisTxKey);
            if (null != txMap) {
                responseDto.setTraceId((String) txMap.get("traceId"));
                List products = (List) txMap.get("itemIds");
                responseDto.setItemIds(products);
                return responseDto;
            }
            RecommendProductRequestDto requestDto = new RecommendProductRequestDto();
            requestDto.setAppId(appId);
            requestDto.setMchId(mchId);
            requestDto.setSubAppId(wxapp.getWxAppid());
            requestDto.setSubMchId(wxapp.getMchId());
            requestDto.setSecret(signKey);
            requestDto.setOpenId(openId);
            requestDto.setSubOpenId(openId);
            requestDto.setScene("MOBILE");
            requestDto.setStoreId(storeId);
            //固定大小传10
            requestDto.setRecommendNum(10);
            RecommendProductResponseDto productResponseDto = recommendClient.recommendProduct(requestDto);
            LogUtil.info("recommendClient.recommendProduct****", gson.toJson(requestDto), gson.toJson(productResponseDto));
            //不成功设置关闭状态
            if (100 != productResponseDto.getCode()) {
                responseDto.setGuessLikeStatus("2");
                return responseDto;
            }
            responseDto.setTraceId(productResponseDto.getTraceId());
            responseDto.setItemIds(productResponseDto.getItemIds());
            //放缓存一小时
            Map reTxMap = Maps.newHashMap();
            reTxMap.put("traceId", productResponseDto.getTraceId());
            reTxMap.put("itemIds", productResponseDto.getItemIds());
            redisCache.save(redisTxKey, reTxMap, 1L, TimeUnit.HOURS);
            return responseDto;
        } catch (Exception e) {
            log.info("猜你喜欢获取推荐商品接口异常" + e);
            return new RecommendProductResponseDto();
        }
    }
}
