package cn.freemud.service.impl;

import cn.freemud.entities.dto.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.dto.activity.ActivityDiscountsDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.service.IPromotionService;
import lombok.Data;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.genid.GenId;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: null.java
 * @Package
 * @Description: (用一句话描述该文件做什么)
 * @author: 蓝胖子(Hector)
 * @date: 2019-10-31
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */

@Service("xyDiscountService")
public class XyDiscountServiceImpl implements IPromotionService {

    @Override
    public void updateShoppingCartGoodsDiscount(CouponPromotionVO couponPromotionVO, ActivityQueryDto activityQueryDto, ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult, List<CartGoods> cartGoodsList, ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo, UserLoginInfoDto userLoginInfoDto, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {
        //ApportionGoodsDetail apportionGoodsDetail = getApportionGoodsDetail(calculationDiscountResult);
        //if (apportionGoodsDetail != null) {
        //    Optional<CartGoods> firstCartGoods = cartGoodsList.stream().filter(cartGoods -> ObjectUtils.equals(apportionGoodsDetail.getGoodsId(), cartGoods.getGoodsId())).findFirst();
        //    if (firstCartGoods.isPresent()) {
        //        firstCartGoods.get().setAmount(firstCartGoods.get().getAmount() - apportionGoodsDetail.getActivityApportionAmount());
        //    }
        //}
        List<ApportionGoodsDetail> apportionGoodsDetail = getApportionGoodsDetail(calculationDiscountResult);
        if (apportionGoodsDetail != null && apportionGoodsDetail.size() > 0) {
            for (CartGoods cartGoods : cartGoodsList) {
                for (ApportionGoodsDetail detail : apportionGoodsDetail) {
                    if (detail.getCartGoodsUid().equals(cartGoods.getCartGoodsUid())) {
                        cartGoods.setAmount(cartGoods.getAmount() - detail.getActivityApportionAmount());
                    }
                }
            }
        }
    }

    @Override
    public void updateShoppingCartGoodsApportion(ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo, ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult, ShoppingCartGoodsDto shoppingCartGoodsDto, CreateOrderVo.PremiumExchangeActivity premiumExchangeActivity, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {
        //ApportionGoodsDetail apportionGoodsDetail = getApportionGoodsDetail(calculationDiscountResult);
        //if (apportionGoodsDetail != null) {
        //    Optional<ShoppingCartGoodsDto.CartGoodsDetailDto> firstCartGoods = shoppingCartGoodsDto.getProducts().stream().filter(cartGoods -> ObjectUtils.equals(apportionGoodsDetail.getGoodsId(), cartGoods.getSkuId())).findFirst();
        //    if (firstCartGoods.isPresent()) {
        //        ShoppingCartGoodsDto.CartGoodsDetailDto cartGoods = firstCartGoods.get();
        //        cartGoods.setTotalDiscountAmount(cartGoods.getTotalDiscountAmount() + apportionGoodsDetail.getActivityApportionAmount().intValue());
        //        List<ActivityDiscountsDto> activityDiscountsDtoList = new ArrayList<>();
        //        ActivityDiscountsDto activityDiscountsDto = new ActivityDiscountsDto();
        //        activityDiscountsDto.setActivityCode(apportionGoodsDetail.getActivityCode());
        //        activityDiscountsDto.setActivityName(apportionGoodsDetail.getActivityName());
        //        activityDiscountsDto.setActivityType(ActivityTypeEnum.TYPE_104.getCode());
        //        activityDiscountsDto.setDiscountAmount(apportionGoodsDetail.getActivityApportionAmount().intValue());
        //        activityDiscountsDtoList.add(activityDiscountsDto);
        //        cartGoods.setActivityDiscountsDtos(activityDiscountsDtoList);
        //    }
        //}
        List<ApportionGoodsDetail> apportionGoodsDetail = getApportionGoodsDetail(calculationDiscountResult);
        if (apportionGoodsDetail != null && apportionGoodsDetail.size() > 0) {
            for (ShoppingCartGoodsDto.CartGoodsDetailDto product : shoppingCartGoodsDto.getProducts()) {
                for (ApportionGoodsDetail detail : apportionGoodsDetail) {
                    if (detail.getCartGoodsUid().equals(product.getCartGoodsUid())) {
                        product.setTotalDiscountAmount(product.getTotalDiscountAmount() + detail.getActivityApportionAmount().intValue());
                        List<ActivityDiscountsDto> activityDiscountsDtoList = new ArrayList<>();
                        ActivityDiscountsDto activityDiscountsDto = new ActivityDiscountsDto();
                        activityDiscountsDto.setActivityCode(detail.getActivityCode());
                        activityDiscountsDto.setActivityName(detail.getActivityName());
                        activityDiscountsDto.setActivityType(ActivityTypeEnum.TYPE_104.getCode());
                        activityDiscountsDto.setDiscountAmount(detail.getActivityApportionAmount().intValue());
                        activityDiscountsDtoList.add(activityDiscountsDto);
                        product.setActivityDiscountsDtos(activityDiscountsDtoList);
                    }
                }
            }
        }
    }

    /*
    private ApportionGoodsDetail getApportionGoodsDetail(ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult) {
        // 遍历购物车内的商品，如果存在则进行均摊
        if (calculationDiscountResult == null || CollectionUtils.isEmpty(calculationDiscountResult.getApportionGoods())) {
            return null;
        }
        for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods apportionGood : calculationDiscountResult.getApportionGoods()) {
            if (!CollectionUtils.isEmpty(apportionGood.getApportionDetails())) {
                for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.ApportionDetails apportionDetail : apportionGood.getApportionDetails()) {
                    if (apportionDetail.getActivityType().equals(ActivityTypeEnum.TYPE_104.getCode())) {
                        ApportionGoodsDetail apportionGoodsDetail = new ApportionGoodsDetail();
                        apportionGoodsDetail.setActivityApportionAmount(apportionDetail.getActivityApportionAmount());
                        apportionGoodsDetail.setActivityCode(apportionDetail.getActivityCode());
                        apportionGoodsDetail.setActivityName(apportionDetail.getActivityName());
                        apportionGoodsDetail.setGoodsId(apportionGood.getGoodsId());
                        return apportionGoodsDetail;
                    }
                }
            }
        }
        return null;
    }
    */
    private List<ApportionGoodsDetail> getApportionGoodsDetail(ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult) {
        // 遍历购物车内的商品，如果存在则进行均摊
        if (calculationDiscountResult == null || CollectionUtils.isEmpty(calculationDiscountResult.getApportionGoods())) {
            return null;
        }
        List<ApportionGoodsDetail> apportionGoodsDetail = new ArrayList<>();
        for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods apportionGood : calculationDiscountResult.getApportionGoods()) {
            if (!CollectionUtils.isEmpty(apportionGood.getApportionDetails())) {
                for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.ApportionDetails apportionDetail : apportionGood.getApportionDetails()) {
                    if (apportionDetail.getActivityType().equals(ActivityTypeEnum.TYPE_104.getCode())) {
                        ApportionGoodsDetail detail = new ApportionGoodsDetail();
                        detail.setActivityApportionAmount(apportionDetail.getActivityApportionAmount());
                        detail.setActivityCode(apportionDetail.getActivityCode());
                        detail.setActivityName(apportionDetail.getActivityName());
                        detail.setGoodsId(apportionGood.getGoodsId());
                        detail.setCartGoodsUid(apportionGood.getCartGoodsUid());
                        apportionGoodsDetail.add(detail);
                    }
                }
            }
        }
        return apportionGoodsDetail;
    }
    @Data
    private class ApportionGoodsDetail {
        /**
         * 活动code,如果是商品券，优惠券，放券code
         */
        private String activityCode;
        /**
         * 活动名称，如果是商品券，优惠券，放券名称
         */
        private String activityName;
        /**
         * 活动均摊金额
         */
        private Long activityApportionAmount;
        private String goodsId;
        /**
         * 购物车行uid
         */
        private String cartGoodsUid;
    }


}
