/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderSettlementResp
 * @Package com.freemud.application.sdk.api.ordercenter.response.orderInfo
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/2 17:32
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.response.orderInfo;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class OrderSettlementResp {

    /**
     * 订单商品ID
     */
    private String productId;

    /**
     * 商品序号
     */
    private Integer productSeq;

    /**
     * 外部对象ID 如:活动ID
     */
    private String externalObjectId;

    /**
     * 外部对象名称 如：活动名称
     */
    private String externalObjectName;

    /**
     * OrderSettlementType 枚举类
     */
    private Integer settlementType;

    /**
     * 结算金额
     */
    private BigDecimal settlementAmount;

    /**
     * 备注
     */
    private String note;

    /**
     * 优惠覆盖数量
     */
    private Integer number;

    /**
     * 平台优惠
     */
    private Long platformDiscountAmount;

    /**
     * 商家优惠
     */
    private Long shopDiscountAmount;

    /**
     * 代理商优惠
     */
    private Long agentDiscountAmount;

    /**
     * 承运商优惠
     */
    private Long carrierDiscountAmount;

    /**
     * 商户实收总价
     */
    private Long shopAmount;

    /**
     * 平台服务费
     */
    private Long platformServiceAmount;

    /**
     * 是否线上 false:不是 true:是
     */
    private Boolean isOnline;

    /**
     * 结算信息扩展字段映射对象
     */
    private String extInfo;
    /**
     * 商家预计收入
     */
    private BigDecimal prospectiveAmount;
    /**
     * 是否忽略金额计算
     */
    private Boolean ignoreInDiscountAmount;


    // 订单商品名称
    private String productName;
    // 外部子对象
    private String externalObjectSubId;
    // 结算类型名称
    private String settlementTypeName;

}
