package cn.freemud.management.adapter;

import cn.freemud.management.entities.dto.request.console.BizDTO;
import cn.freemud.management.entities.dto.request.console.ConsoleResponseDTO;
import cn.freemud.management.entities.dto.request.console.StoreInfoDTO;
import com.freemud.application.sdk.api.deliverycenter.dto.CreateDeliveryOrderRequestDto;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.enums.OrderType;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Component
public class DeliverySdkAdapter {
    /**
     * 创建配送单请求对象
     *
     * @param order
     * @param bizDTO
     * @param deliveryCallBackUrl
     * @return
     */
    public CreateDeliveryOrderRequestDto buildDeliveryOrderRequestDto(OrderBeanV1 order
            , ConsoleResponseDTO<BizDTO> bizDTO, String deliveryCallBackUrl) {
        StoreInfoDTO storeInfo = bizDTO.getBizVO().getStoreInfo();
        CreateDeliveryOrderRequestDto deliveryOrderRequestDto = new CreateDeliveryOrderRequestDto();
        deliveryOrderRequestDto.setDepatchWeight(new BigDecimal(1));
        deliveryOrderRequestDto.setSerialNumber(order.getOtherCode());
        deliveryOrderRequestDto.setOrderId(order.getOid());
        deliveryOrderRequestDto.setOrderRemark(order.getRemark());
        deliveryOrderRequestDto.setOrderTotalAmount(order.getAmount().intValue());
        deliveryOrderRequestDto.setOrderActualAmount(order.getAmount().intValue());
        deliveryOrderRequestDto.setPartnerId(order.getCompanyId());
        deliveryOrderRequestDto.setOrderChannel(order.getSource());
        deliveryOrderRequestDto.setStoreId(storeInfo.getStoreId());
        deliveryOrderRequestDto.setStoreCode(storeInfo.getStoreCode());
        StringBuffer address = new StringBuffer(storeInfo.getCity())
                .append(storeInfo.getProvince())
                .append(storeInfo.getRegion())
                .append(storeInfo.getAddress());
        deliveryOrderRequestDto.setStoreAddress(address.toString());
        deliveryOrderRequestDto.setStoreLng(new BigDecimal(storeInfo.getLongitude()));
        deliveryOrderRequestDto.setStoreLat(new BigDecimal(storeInfo.getLatitude()));
        deliveryOrderRequestDto.setStorePhone(storeInfo.getPhone());
        deliveryOrderRequestDto.setStoreName(order.getShopName());
        deliveryOrderRequestDto.setCityName(storeInfo.getCity());
        deliveryOrderRequestDto.setReceiverName(order.getUserName());
        deliveryOrderRequestDto.setReceiverPrimaryPhone(order.getPhone());
        deliveryOrderRequestDto.setReceiverAddress(order.getAddress());
        deliveryOrderRequestDto.setReceiverLng(BigDecimal.valueOf(order.getLongitude()));
        deliveryOrderRequestDto.setReceiverLat(BigDecimal.valueOf(order.getLatitude()));
        deliveryOrderRequestDto.setOrderTime(new Date(order.getGmtCreate()));
        deliveryOrderRequestDto.setCallbackUrl(deliveryCallBackUrl);
        deliveryOrderRequestDto.setOrderClient(NumberUtils.toInt(order.getOrderClient()));
        // 预约单预计送到时间
        if (order.getGmtExpect() != null && order.getGmtExpect() != 0) {
            deliveryOrderRequestDto.setExpectTime(new Date(order.getGmtExpect()));
        }
        deliveryOrderRequestDto.setIsPre(order.getNewOrderType() == OrderType.RESERVED_EXPRESS.getIndex() ? 1 : 0);
        Optional.ofNullable(order.getProductList())
                .ifPresent(productList ->
                        deliveryOrderRequestDto.setProductInfos(productList.stream()
                                .filter(productBean -> Objects.nonNull(productBean.getPrice()))
                                .filter(productBean -> productBean.getPrice() > 0)
                                .map(productBean -> {
                                    CreateDeliveryOrderRequestDto.DeliveryProductInfo deliveryProductInfo = new CreateDeliveryOrderRequestDto.DeliveryProductInfo();
                                    deliveryProductInfo.setProductCode(productBean.getProductId());
                                    deliveryProductInfo.setProductName(productBean.getProductName());
                                    deliveryProductInfo.setProductNumber(productBean.getNumber());
                                    deliveryProductInfo.setProductPrice(productBean.getPrice().intValue());
                                    return deliveryProductInfo;
                                }).collect(Collectors.toCollection(LinkedList::new))));
        return deliveryOrderRequestDto;
    }
}
