/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: QueryOrderResponse
 * @Package cn.freemud.entities.dto
 * @Description: 订单列表
 * @author: liming.guo
 * @date: 2018/5/24 17:37
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto.promotion;


import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;


@NoArgsConstructor
@Data
public class OrderBeanRequest {
    private String appId;
    /**
     * 总金额
     */
    private Long amount;
    /**
     * 吧台桌号
     */
    private String barCounter;
    /**
     * 取消原因
     */
    private String cancelReason;
    /**
     * 商户ID
     */
    private String companyId;


    private Integer orderType;
    /**
     * 取餐码
     */
    private String otherCode;

    private String shopId;
    private String shopName;
    private String source;
    private String sourceName;

    /**
     * 订单类型   1 外卖 2 预订单 3 商城 4 打包带走 5 店内就餐
     */
    private Integer type;
    /**
     * 用户ID
     */
    private String userId;
    /**
     * 用户名称
     */
    private String userName;
    private String userType;

    private List<ProductBean> productList;

    @NoArgsConstructor
    @Data
    public static class ProductBean {
        /**
         * customerCode :
         * number : 1
         * opid : 0
         * orderId : 109457845547698183
         * parentProduct :
         * picture :
         * price : 1100
         * productId : product1
         * productName : 奶茶
         * sequence : 10
         * specification : 中杯+常温
         * specificationName :
         * unit :
         */
        /**
         * 重量
         */
        private BigDecimal weight;
        /**
         * 优惠分摊金额
         */
        private BigDecimal productSharePrice;
        private String customerCode;
        /**
         * 商品货号，商品服务可重复
         */
        private String productCode;
        /**
         * 商品数量
         */
        private int number;
        /**
         * 订单ID
         */
        private String orderId;
        /**
         * 商品ID
         */
        private String productId;
        /**
         * 父类商品ID
         */
        private String parentProductId;
        /**
         * 商品图片
         */
        private String picture;
        /**
         * 商品价格
         */
        private Long price;
        /**
         * 商品实际销售价格 扣除优惠价格后计算salePrice V1.5.2增加
         */
        private Long salePrice;
        /**
         * 均摊价格
         */
        private Long settlementPrice;
        /**
         * 包装价
         */
        private Long packAmount;
        /**
         * 商品名称
         */
        private String productName;
        /**
         * 商品排序
         */
        private int sequence;
        /**
         * 商品描述
         */
        private String specification;
        private String specificationName;
        private String unit;
        /**
         * 商品扩展字段 保存为
         */
        private String addInfo;

        /**
         * 商品type
         */
        private Integer productType;
        
        /**
         * 原总价 
         */
        private Long originalAmount;

        /**
         * 是否固定商品
         */
        private Boolean isFixedProduct;

        /**
         * 套餐子商品
         */
        private List<ProductBean> comboProduct;

    }

}


