package cn.freemud.service.impl.mcoffee.entity;

import cn.freemud.entities.vo.*;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * All rights Reserved, Designed By sunary.site
 *
 * @version v1.0
 * @Title: IntelliJ IDEA
 * @Package cn.freemud.service.impl.mcoffee.entity
 * @Description: 请简单描述下这个类是做什么用的
 * @author: yu.sun
 * @date: 2021-01-26 09:50:21
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 */
@Data
public class BatchGoodsInfoVo {
    @NotEmpty(message = "spuId不能为空")
    private String spuId;

    private String skuId;

    /**
     * 数量
     */
    @NotNull(message = "商品数量不可为空")
    private Integer qty;

    /**
     * 操作类型 1= 添加商品券 2=加价购
     */
    private Integer operationType;


    /**
     * 套餐名称
     */
    private String groupName;

    /**
     * 1.6.0 版本增加 分类名
     */
    private String categoryName;
    /**
     * 商品额外的属性
     */
    private List<CartGoods.CartGoodsExtra> extra;
    /**
     * 套餐固定商品
     */
    private List<ComboxGoodsRequestVo> productComboList;
    /**
     * 套餐可选商品
     */
    private List<ComboxGoodsRequestVo> productGroupList;

    /**
     * 加料
     */
    private List<MaterialRequestVo> productMaterialList;

    /**
     * 麦咖啡定制属性
     */
    private List<CartGoods.SpecialExtra> specialExtra;

    /**
     * 券类型 0：商品券
     */
    private Integer couponType;
    /**
     * 商品券门槛金额
     */
    private Long couponThresholdAmount;

    /**
     * 是否是太阳蛋商品
     */
    private int isSunnyCoupon = 0;

    /**
     * 优惠券号
     */
    private String couponCode;

    /**
     * 当前商品是否为月享卡，0:否，1:是
     */
    private int isMonthCard;

    private int isB3S1Coupon;
    /**
     * 是否为月享卡商品
     */
    private int isMonthCardGoods;
    /**
     * 月享卡加购信息
     */
    private MonthCardVo monthCardInfo;
    /**
     * 月享卡加购信息
     */
    private B3S1CouponGoodsInfoVo b3S1CouponGoodsInfo;
}
