package cn.freemud.demo.service.impl;

import cn.freemud.adapter.CouponAdapter;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.demo.entities.bo.goods.ValidateShopProductRequestBO;
import cn.freemud.demo.entities.bo.goods.ShoppingCartGoodsBO;
import cn.freemud.demo.entities.bo.goods.*;
import cn.freemud.demo.entities.bo.goods.list.ListCartGoodsBO;
import cn.freemud.demo.entities.bo.promotion.GetCalculationDiscountBO;
import cn.freemud.demo.entities.bo.store.GetStoreBO;
import cn.freemud.demo.manager.customer.CustomerManager;
import cn.freemud.demo.manager.product.ProductManager;
import cn.freemud.demo.manager.store.StoreManager;
import cn.freemud.demo.service.impl.AbstractListCartGoodsService;
import cn.freemud.demo.service.impl.DeliveryService;
import cn.freemud.entities.dto.CheckSpqInfoRequestDto;
import cn.freemud.entities.dto.CheckSpqInfoResponseDto;
import cn.freemud.entities.vo.ActivityClassifyCouponBean;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.CouponPromotionVO;
import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import cn.freemud.enums.*;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.CouponService;
import cn.freemud.utils.PropertyConvertUtil;
import com.freemud.application.sdk.api.log.ApiLog;
import com.freemud.application.sdk.api.productcenter.request.product.valid.ValidateShopProductType;
import com.freemud.sdk.api.assortment.shoppingcart.constant.CommonsConstant;
import com.freemud.sdk.api.assortment.shoppingcart.enums.BusinessTypeEnum;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.toList;

@Service
public class PlatformListCartGoodsService extends AbstractListCartGoodsService {

    private static Integer MAX_SHOP_LENGTH = 32;

    @Autowired
    private StoreManager storeManager;
    @Autowired
    private CustomerManager customerManager;
    @Autowired
    private ProductManager productManager;
    @Autowired
    private CouponService couponService;


    @Autowired
    private DeliveryService deliveryService;

    @Autowired
    private CouponAdapter couponAdapter;

    @Override
    public BaseResponse checkCustomParams(ListCartGoodsBO baseRequestDTO) {

        return ResponseBuilder.success();
    }

    @Override
    public CalCostBO getDiscountResultBefore(ListCartGoodsBO baseRequestDTO, DiscountResultBO discountResultBO) {
        // 计算配送费
        CalCostBO calCostBO = new CalCostBO();
        List<CartGoods> cartGoodsList = discountResultBO.getCartGoods();
        Long deliveryAmount = deliveryService.calculateDeliveryAmount(baseRequestDTO.getReceiveId(), baseRequestDTO.getPartnerId(), baseRequestDTO.getShopId(),
                baseRequestDTO.getOrderType(), baseRequestDTO.getManagerService());

        ArrayList<GetCalculationDiscountBO.CalculationDiscountCoupon > coupons = new ArrayList<>();
        if (StringUtils.isNotEmpty(baseRequestDTO.getCouponCode())) {
            GetCalculationDiscountBO.CalculationDiscountCoupon  coupon = new GetCalculationDiscountBO.CalculationDiscountCoupon ();
            coupon.setCode(baseRequestDTO.getCouponCode());
            coupon.setActivityCode(baseRequestDTO.getActivityCode());
            coupons.add(coupon);
        }

        buildCoupons(coupons, baseRequestDTO.getCouponCodes());

        List<ListCartGoodsBO.SendGoods> sendGoodsList = baseRequestDTO.getSendGoods();
        List<ShoppingCartInfoRequestVo.SendGoods> sendGoods = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(sendGoodsList)) {
            for (ListCartGoodsBO.SendGoods sds : sendGoodsList) {
                ShoppingCartInfoRequestVo.SendGoods sd = new ShoppingCartInfoRequestVo.SendGoods();
                sd.setGoodsId(sds.getGoodsId());
                if (StringUtils.isBlank(sds.getActivityCode())) continue;
                sd.setQty(sds.getQty());
                sd.setOriginalPrice(0L);
                sd.setActivityCode(sds.getActivityCode());
                sendGoods.add(sd);
            }
        }


        // 拼促销请求的dto
        GetCalculationDiscountBO calculationSharingDiscountRequestDto = this.commonSharingDto(baseRequestDTO.getPartnerId(), baseRequestDTO.getShopId(),
                baseRequestDTO.getUserId(), baseRequestDTO.getAppId(), baseRequestDTO.getOrderType());

        // 校验后有效的商品券map
        List<GetCalculationDiscountBO.CalculationDiscountGoods> calculationDiscountGoodsList = new ArrayList<>();
        int cartSize = cartGoodsList.size() - 1;
        for (int i = cartSize; i >= 0; i--) {
            CartGoods cartGoods = cartGoodsList.get(i);
            if (!cartGoods.getCartGoodsUid().startsWith(CommonsConstant.COUPON_PREFIX)) {//非商品券
                this.setCommonDiscountGoods(calculationDiscountGoodsList,cartGoods);
            }
            else {//商品券->商品券ID换取商品
                String goodsId = StringUtils.isNotBlank(cartGoods.getSkuId()) ? cartGoods.getSkuId() : cartGoods.getSpuId();
                GetCalculationDiscountBO.CalculationDiscountCoupon coupon = new GetCalculationDiscountBO.CalculationDiscountCoupon();
                coupon.setCode(cartGoods.getCouponCode());
                coupon.setActivityCode(cartGoods.getActivityCode());
                coupons.add(coupon);
                if (GoodsTypeEnum.HG_COUPON_GOODS.getGoodsType().equals(cartGoods.getGoodsType())) {
                    this.setSpqDiscountGoods(calculationDiscountGoodsList, cartGoods, goodsId, cartGoods.getOriginalPrice(), cartGoods.getSpuId());
                } else {
                    this.setSpqDiscountGoods(calculationDiscountGoodsList, cartGoods, goodsId, cartGoods.getOriginalPrice(), null);
                }
            }
        }

        /*加价购商品不为空*/
        if (CollectionUtils.isNotEmpty(sendGoodsList)) {
            String activityCode = "";
            List<GetCalculationDiscountBO.CalculationSendGoodsReqVO> sends = new ArrayList<>();
            List<GetCalculationDiscountBO.CalculationActivityReqVO> selectActivityLists = new ArrayList<>();
            GetCalculationDiscountBO.CalculationActivityReqVO calculationActivityReqVO = new GetCalculationDiscountBO.CalculationActivityReqVO();
            for (ListCartGoodsBO.SendGoods send : sendGoodsList) {
                GetCalculationDiscountBO.CalculationSendGoodsReqVO reqs = new GetCalculationDiscountBO.CalculationSendGoodsReqVO();
                reqs.setGoodsId(send.getGoodsId());
                reqs.setGoodsQuantity(send.getQty());
                reqs.setOriginalPrice(send.getOriginalPrice().intValue());
                reqs.setNowPrice(send.getOriginalPrice().intValue());
                sends.add(reqs);
                activityCode = send.getActivityCode();
            }
            calculationActivityReqVO.setActivityCode(activityCode);
            calculationActivityReqVO.setSendGoods(sends);
            selectActivityLists.add(calculationActivityReqVO);
            calculationSharingDiscountRequestDto.setSelectActivityList(selectActivityLists);
        }

        //组装促销
        calculationSharingDiscountRequestDto.setGoods(calculationDiscountGoodsList);
        calculationSharingDiscountRequestDto.setCoupons(coupons);
        calculationSharingDiscountRequestDto.setOrgIds(baseRequestDTO.getManagerService().getStoreService().getOrgIds(new GetStoreBO(baseRequestDTO.getPartnerId(), baseRequestDTO.getShopId())));
        calculationSharingDiscountRequestDto.setDistributionFee(deliveryAmount);
        calculationSharingDiscountRequestDto.setIsMember(discountResultBO.getIsMember());

        calCostBO.setGetCalculationDiscountBO(calculationSharingDiscountRequestDto);
        calCostBO.setValidCouponMap(discountResultBO.getValidCouponMap());
        calCostBO.setCartGoods(discountResultBO.getCartGoods());
        return calCostBO;
    }

    @Override
    public CalCostBO getDiscountResultAfter(ListCartGoodsBO baseRequestDTO, DiscountResultBO calCostBO, CalCostBO commonSetMessageBO) {
        return commonSetMessageBO;
    }

    @Override
    public SetMessageBO customDistribute(ListCartGoodsBO baseRequestDTO, DistributeBO calCostBO, SetMessageBO commonSetMessageBO) {
        ShoppingCartGoodsBO shoppingCartGoodsBO = commonSetMessageBO.getShoppingCartGoodsBO();
        List<CartGoods> cartGoodsList = commonSetMessageBO.getCartGoods();
        CouponPromotionVO couponPromotionVO = couponAdapter.getCouponPromotionVO(baseRequestDTO);

        // 用户选择了查询优惠券信息
        if (couponPromotionVO != null && ObjectUtils.equals(CouponFlag.YES.getCode(), couponPromotionVO.getFlg())) {
            List<CartGoods> tmpCartGoods = cartGoodsList.parallelStream().filter(k -> k.getCartGoodsUid()
                    .startsWith(CommonsConstant.COUPON_PREFIX)).collect(Collectors.toList());
            // 是否存在商品券
            boolean hasGoodssCoupon = CollectionUtils.isNotEmpty(tmpCartGoods);
            // 构建可用不可用优惠券
            ActivityClassifyCouponBean activityClassifyCouponBean = couponService.availableCoupon(cartGoodsList
                    , couponPromotionVO.getPartnerId()
                    , couponPromotionVO.getUserId()
                    , couponPromotionVO.getStoreId()
                    , couponPromotionVO.getCouponCode()
                    , hasGoodssCoupon
                    , couponPromotionVO.getOrderType()
                    , 1
                    , baseRequestDTO.getAppId()
            );
            if (Objects.equals(activityClassifyCouponBean, null)) {
                // 构建一个空得订单券信息
                activityClassifyCouponBean = createEmptyActivityCouponBean();
            }
            shoppingCartGoodsBO.setAvailableCoupon(activityClassifyCouponBean);
        } else {
            // 构建一个空得订单券信息
            ActivityClassifyCouponBean activityClassifyCouponBean = createEmptyActivityCouponBean();
            shoppingCartGoodsBO.setAvailableCoupon(activityClassifyCouponBean);
        }
        CalculationDiscountBO.CalculationDiscountResult discountResult = null;
        if (calCostBO.getCalculationDiscountBO() != null){
            discountResult = calCostBO.getCalculationDiscountBO().getResult();
        }
        // 当couponCode不为空时，需计算优惠价格 3代金 31折扣  32商品  33换购券
        shoppingCartGoodsBO.setCouponDiscount(0L);
        //循环购物车商品券
        for (CartGoods cartGoods : cartGoodsList) {
            if (cartGoods.getCartGoodsUid().startsWith(CommonsConstant.COUPON_PREFIX)) {
                String spqId = cartGoods.getCartGoodsUid().substring(CommonsConstant.COUPON_PREFIX.length());
                // 计算优惠信息时，已将券校验过，放在map中
                Map<String, CheckSpqInfoResponseDto> validCouponMap = discountResult == null ? new HashMap<>() : discountResult.getValidCouponMap();
                if (MapUtils.isNotEmpty(validCouponMap)) {
                    CheckSpqInfoResponseDto checkSpqInfoResponseDto = validCouponMap.get(spqId);
                    if (checkSpqInfoResponseDto != null) {
                        cartGoods.setOriginalPrice(checkSpqInfoResponseDto.getPrice());
                        cartGoods.setSpuId(checkSpqInfoResponseDto.getSpuId());
                        cartGoods.setSkuId(StringUtils.isEmpty(checkSpqInfoResponseDto.getSkuId()) ? checkSpqInfoResponseDto.getSpuId() : checkSpqInfoResponseDto.getSkuId());
                        cartGoods.setQty(1);
                        cartGoods.setCouponCode(checkSpqInfoResponseDto.getCouponCode());
                        cartGoods.setSpuName(checkSpqInfoResponseDto.getSpuName());
                        cartGoods.setSpecProductId(checkSpqInfoResponseDto.getDefaultSpecId());
                        cartGoods.setSubName(checkSpqInfoResponseDto.getDefaultSpecName());
                        cartGoods.setExtra(checkSpqInfoResponseDto.getExtras());
                        if (GoodsTypeEnum.HG_COUPON_GOODS.getGoodsType().equals(cartGoods.getGoodsType())) {
                            CalculationDiscountBO.CalculationDiscountResult.Goods discountGoods = discountResult.getGoods()
                                    .stream()
                                    .filter(d -> cartGoods.getCartGoodsUid().equals(d.getCartGoodsUid()))
                                    .findFirst()
                                    .orElse(null);
                            if (discountGoods != null) {
                                cartGoods.setAmount(discountGoods.getRealAmount());
                            } else {
                                cartGoods.setAmount(checkSpqInfoResponseDto.getPrice());
                            }
                        }
                        cartGoods.setOriginalAmount(checkSpqInfoResponseDto.getPrice());
                    }
                }
            }
        }
        return commonSetMessageBO;

    }

    @Override
    public AddGoodsToShoppingCartBO checkCustomBusinessRules(ListCartGoodsBO baseRequestDTO, CheckBussinessRulesBO checkBussinessRulesBO, AddGoodsToShoppingCartBO addGoodsToShoppingCartBO) {
        // 校验后有效的商品券map
        List<CartGoods> cartGoodsList = addGoodsToShoppingCartBO.getCartGoods();
        HashMap<String, CheckSpqInfoResponseDto> validCouponMap = new HashMap<>(16);
        for (int i = 0; i < cartGoodsList.size(); i++){
            CartGoods cartGoods = cartGoodsList.get(i);
            if (cartGoods.getCartGoodsUid().startsWith(CommonsConstant.COUPON_PREFIX)){
                String spqId = cartGoods.getCartGoodsUid().substring(CommonsConstant.COUPON_PREFIX.length());
                CheckSpqInfoRequestDto checkSpqInfoRequestDto = new CheckSpqInfoRequestDto(baseRequestDTO.getPartnerId(), baseRequestDTO.getShopId(), spqId, baseRequestDTO.getMenuType());
                CheckSpqInfoResponseDto checkSpqInfo = null;
                if (GoodsTypeEnum.HG_COUPON_GOODS.getGoodsType().equals(cartGoods.getGoodsType())) {
                    checkSpqInfo = couponService.checkSpqInfo(checkSpqInfoRequestDto, cartGoods.getSkuId());
                } else {
                    checkSpqInfo = couponService.checkSpqInfo(checkSpqInfoRequestDto);
                }
                if (null == checkSpqInfo) {
                    cartGoodsList.remove(i);
                } else {
                    validCouponMap.put(spqId, checkSpqInfo);
                    addGoodsToShoppingCartBO.setValidCouponMap(validCouponMap);
                }
            }
        }

        return addGoodsToShoppingCartBO;
    }

    private List<GetCalculationDiscountBO.CalculationDiscountCoupon> buildCoupons(List<GetCalculationDiscountBO.CalculationDiscountCoupon> oldCoupons, List<ListCartGoodsBO.couponCode> coupons){


        ApiLog.info("批量使用优惠券前，oldCoupons,coupons",oldCoupons,coupons);

        for(int i = 0 ; i < oldCoupons.size() ; i++){
            GetCalculationDiscountBO.CalculationDiscountCoupon oldCoupon = oldCoupons.get(i);
            oldCoupon.setUseIndex(i);
        }



        List<String> codes = oldCoupons.stream().map(GetCalculationDiscountBO.CalculationDiscountCoupon::getCode).collect(toList());

        if (coupons != null) {
            for(int x = 0 ; x < coupons.size() ; x++){
                ListCartGoodsBO.couponCode cp  = coupons.get(x);
                if(codes.contains(cp.getCouponCode())){
                    continue;
                }
                GetCalculationDiscountBO.CalculationDiscountCoupon coupon = new GetCalculationDiscountBO.CalculationDiscountCoupon();
                coupon.setCode(cp.getCouponCode());
                coupon.setActivityCode(cp.getActivityCode());
                coupon.setUseIndex(cp.getIndex() == null ? x + oldCoupons.size():  cp.getIndex() + oldCoupons.size());
                oldCoupons.add(coupon);
            }
        }

        ApiLog.info("批量使用优惠券后，oldCoupons,coupons",oldCoupons,coupons);

        return oldCoupons;
    }

    private ValidateShopProductRequestBO getValidateShopProductRequestBO(ProductBO product, ListCartGoodsBO baseRequestDTO) {
        ValidateShopProductRequestBO request = new ValidateShopProductRequestBO();
        request.setChannel(baseRequestDTO.getMenuType());
        request.setPartnerId(baseRequestDTO.getPartnerId());
        request.setStoreId(baseRequestDTO.getShopId());
        List<ValidateShopProductType> productTypeList = new ArrayList<>();
        ValidateShopProductType productType = new ValidateShopProductType();

        productType.setAttributeList(null);
        productType.setComboProductTypeList(null);
        productType.setMemberDiscount(null);
        productType.setPrice(product.getFinalPrice().intValue());
        productType.setProductGroupTypeList(null);
        productType.setSpuId(product.getSpuId());
        productType.setUuid(UUID.randomUUID().toString());
        productType.setValidateAttribute(0);
        productType.setValidatePrice(0);
        productType.setValidateStatuses(null);

        productTypeList.add(productType);
        request.setProductTypeList(productTypeList);
        return  request;

    }

    /**
     * 公共DTO头
     *
     * @param partnerId
     * @param storeId
     * @param userId
     * @param appId
     * @param orderType
     * @return
     */
    private GetCalculationDiscountBO commonSharingDto(String partnerId, String storeId, String userId, String appId, Integer orderType) {
        GetCalculationDiscountBO calculationSharingDiscountRequestDto = new GetCalculationDiscountBO();

        calculationSharingDiscountRequestDto.setPartnerCode(partnerId);
        calculationSharingDiscountRequestDto.setStoreId(storeId);
        calculationSharingDiscountRequestDto.setIsShowGoodsActivity(1);
        calculationSharingDiscountRequestDto.setUserId(userId);
        calculationSharingDiscountRequestDto.setAppId(appId);
        calculationSharingDiscountRequestDto.setVer(1);
        calculationSharingDiscountRequestDto.setSelectActivityList(new ArrayList<>());
        ActivityChannelEnum activityChannelEnum = PropertyConvertUtil.orderTypeConvert2ActivityChannel(orderType);
        if (!Objects.isNull(activityChannelEnum)) {
            calculationSharingDiscountRequestDto.setChannel(activityChannelEnum.getCode());
        }

        //==========================  购物车查询特有逻辑  =================================
        // 到店自取包装费设为null,外卖要计算包装费，flag为1表示去结算
        // 兼容老版本判断null
        if (Objects.equals(orderType, CreateOrderType.COLLECT_GOODS.getCode())) {
            calculationSharingDiscountRequestDto.setProductChannel(BusinessTypeEnum.SAAS_PICKUP.getCode());
        } else if (Objects.equals(orderType, CreateOrderType.TAKE_OUT.getCode())) {
            calculationSharingDiscountRequestDto.setProductChannel(BusinessTypeEnum.SAAS_DELIVERY.getCode());
        }
        return calculationSharingDiscountRequestDto;
    }

    /**
     * 实物商品
     * @param calculationDiscountGoodsList
     * @param cartGoods
     */
    private void setCommonDiscountGoods(List<GetCalculationDiscountBO.CalculationDiscountGoods> calculationDiscountGoodsList
            , CartGoods cartGoods) {

        GetCalculationDiscountBO.CalculationDiscountGoods calculationDiscountGoods = new GetCalculationDiscountBO.CalculationDiscountGoods();
        calculationDiscountGoods.setGoodsId(cartGoods.getGoodsId());
        calculationDiscountGoods.setCartGoodsUid(cartGoods.getCartGoodsUid());
        calculationDiscountGoods.setGoodsQuantity(cartGoods.getQty());
        //if (cartGoods.getGoodsType().equals(GoodsTypeEnum.SET_MEAL_GOODS))
        if (CollectionUtils.isNotEmpty(cartGoods.getProductGroupList()) || CollectionUtils.isNotEmpty(cartGoods.getProductComboList())) {
            calculationDiscountGoods.setOriginalPrice(cartGoods.getFinalPrice()!=null ? cartGoods.getFinalPrice() : cartGoods.getOriginalPrice());
        }
        else {
            calculationDiscountGoods.setOriginalPrice(cartGoods.getOriginalPrice());
        }
        calculationDiscountGoods.setMemberDiscount(cartGoods.getMemberDiscount());
        calculationDiscountGoods.setSpuId(cartGoods.getSpuId());
        //商品加料
        if (CollectionUtils.isNotEmpty(cartGoods.getProductMaterialList())) {
            ArrayList<GetCalculationDiscountBO.CalculationDiscountGoods.Material> materials = new ArrayList<>();
            for (CartGoods.MaterialGoods materialGoods : cartGoods.getProductMaterialList()) {
                GetCalculationDiscountBO.CalculationDiscountGoods.Material material = new GetCalculationDiscountBO.CalculationDiscountGoods.Material();
                material.setType(1);
                material.setGoodsId(materialGoods.getSpuId());
                material.setGoodsQuantity(1);
                material.setOriginalPrice(materialGoods.getFinalPrice());
                materials.add(material);
            }
            calculationDiscountGoods.setSmallMaterial(materials);
        }
        //商品组或是套餐或是固定搭配
        if (CollectionUtils.isNotEmpty(cartGoods.getProductComboList())) {
            ArrayList<GetCalculationDiscountBO.CalculationDiscountGoods.GroupCombox> groupBoxes = new ArrayList<>();
            for (CartGoods.ComboxGoods boxes : cartGoods.getProductComboList()) {
                GetCalculationDiscountBO.CalculationDiscountGoods.GroupCombox combo = new GetCalculationDiscountBO.CalculationDiscountGoods.GroupCombox();
                combo.setGoodsId(boxes.getGoodsId());
                combo.setGoodsQuantity(boxes.getQty());
                combo.setOriginalPrice(boxes.getOriginalPrice().intValue());
                groupBoxes.add(combo);
            }
            calculationDiscountGoods.setMeal(true);
            calculationDiscountGoods.setGroupCombox(groupBoxes);
            calculationDiscountGoods.setOriginalPrice(cartGoods.getFinalPrice());
        }

        //可选搭配
        if (CollectionUtils.isNotEmpty(cartGoods.getProductGroupList())) {
            ArrayList<GetCalculationDiscountBO.CalculationDiscountGoods.Material> groups = new ArrayList<>();
            for (CartGoods.ComboxGoods group : cartGoods.getProductGroupList()) {
                GetCalculationDiscountBO.CalculationDiscountGoods.Material material = new GetCalculationDiscountBO.CalculationDiscountGoods.Material();
                material.setType(2);
                material.setGoodsId(group.getGoodsId());
                material.setGoodsQuantity(group.getQty());
                material.setOriginalPrice(group.getFinalPrice());
                groups.add(material);
            }
            calculationDiscountGoods.setSmallMaterial(groups);
        }
        calculationDiscountGoodsList.add(calculationDiscountGoods);
    }

    private void setSpqDiscountGoods(List<GetCalculationDiscountBO.CalculationDiscountGoods> calculationDiscountGoodsList
            , CartGoods cartGoods
            , String goodsId
            , Long originalPrice
            ,String couponCode) {
        GetCalculationDiscountBO.CalculationDiscountGoods calculationDiscountGoods = new GetCalculationDiscountBO.CalculationDiscountGoods();
        calculationDiscountGoods.setGoodsId(goodsId);
        calculationDiscountGoods.setCartGoodsUid(cartGoods.getCartGoodsUid());
        calculationDiscountGoods.setGoodsQuantity(1);
        calculationDiscountGoods.setOriginalPrice(originalPrice);
        calculationDiscountGoods.setMemberDiscount(100);
        calculationDiscountGoods.setCouponCode(couponCode);
        this.setCalculationDiscountGoods(calculationDiscountGoodsList,calculationDiscountGoods);
    }

    /**
     * 需要促销计算的商品
     * @param calculationDiscountGoodsList
     * @param calculationDiscountGoods
     */
    private void setCalculationDiscountGoods(List<GetCalculationDiscountBO.CalculationDiscountGoods> calculationDiscountGoodsList
            ,GetCalculationDiscountBO.CalculationDiscountGoods calculationDiscountGoods) {
        int index = 0;
        //当商品已经存在时，需要累加数量
        if ((index = calculationDiscountGoodsList.indexOf(calculationDiscountGoods))>=0) {
            GetCalculationDiscountBO.CalculationDiscountGoods old = calculationDiscountGoodsList.get(index);
            calculationDiscountGoodsList.get(index).setGoodsQuantity(old.getGoodsQuantity()+calculationDiscountGoods.getGoodsQuantity());
        }
        else {
            calculationDiscountGoodsList.add(calculationDiscountGoods);
        }

    }

    public ActivityClassifyCouponBean createEmptyActivityCouponBean() {
        ActivityClassifyCouponBean activityClassifyCouponBean = new ActivityClassifyCouponBean();
        activityClassifyCouponBean.setCouponNum(0);
        activityClassifyCouponBean.setDisableCouponNum(0);
        activityClassifyCouponBean.setUsableCouponNum(0);
        activityClassifyCouponBean.setDisableCoupons(Lists.newArrayList());
        activityClassifyCouponBean.setUsableCoupons(Lists.newArrayList());
        return activityClassifyCouponBean;
    }

}
