package cn.freemud.demo.adapter.manager;

import cn.freemud.demo.entities.bo.promotion.ActivityBO;
import cn.freemud.demo.entities.bo.goods.CalculationDiscountBO;
import cn.freemud.entities.dto.ActivityResponseDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.utils.BeanUtil;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class PromotionDTO2BOAdapter {


    @Resource
    private MapperFacade mapperFacade;

    public CalculationDiscountBO convert2CalculationDiscountBO(CalculationSharingDiscountResponseDto dto) {

        CalculationDiscountBO bo = mapperFacade.map(dto, CalculationDiscountBO.class);

        return bo;
    }

    public ActivityBO convert2ActivityBO(ActivityResponseDto dto) {

        ActivityBO bo = BeanUtil.convertBean(dto, ActivityBO::new);
        return bo;
    }


}
