package cn.freemud.demo.entities.bo.goods.list;

import cn.freemud.demo.entities.bo.goods.ManagerServiceBO;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class ListCartGoodsBO {

    private String sessionId;

    private String userId;

    private String partnerId;

    private String shopId;

    @NotEmpty(message = "spuId不能为空")
    private String spuId;

    private String skuId;


    private ManagerServiceBO managerService;

    private CartGoods addGoods;
    /**
     * 会员卡信息
     */
    private ShoppingCartInfoRequestVo.BuyMemberCard buyMemberCard;
    /**
     * 到店类型  orderType 传1的时候    如果reachStoreTyp为空转成订单类型4  如果不为空存储4(打包带走)和5（店内就餐）
     */
    private Integer reachStoreType;

    /**
     * 是否为结算页
     *  1：结算页 0：点餐页
     * 结算页会查询用户优惠券，点餐页不会查询用户优惠券
     */
    private Integer flag;

    /**
     * 加价购商品
     */
    private List<SendGoods> sendGoods;

    /**
     * 活动号
     */
    private String activityCode;

    /**
     * 优惠券code列表
     */
    private List<couponCode> couponCodes;

    /**
     * 微信appId
     */
    @NotEmpty(message = "appId不能为空")
    private String appId;

    /**
     * 是否使用用户积分
     * 1=不显示积分
     * 2=显示积分但不扣减
     * 3=显示积分且扣减
     */
    private Integer useCustomerScore;

    /**
     * 收货地址ID、svc卡支付外卖订单必传
     */
    private String receiveId;

    /**
     * 操作类型 1= 添加商品券 2=加价购
     */
    private Integer operationType;

    /**
     * 优惠券号
     */
    private String couponCode;

    private String wxappid;

    /**
     * 下单类型 CreateOrderType 外卖、到店、商城
     */
    private Integer orderType;

    /**
     * 渠道类型 OrderChannelType
     */
    private String channelType;

    /**
     * 购物车版本号（拼单）
     */
    private Integer carVer;

    /**
     * 业务类型： 0 : 自提 1：外卖 2：微商城
     */
    private String menuType ;

    private String tableNumber;

    @Data
    public final static class couponCode {
        /**
         * 优惠券
         */
        private String couponCode;
        /**
         * 活动号
         */
        private String activityCode;

        /**
         * 顺序
         */
        private Integer index;
    }

    @Data
    public final static class SendGoods {
        /**
         * 商品Id
         */
        @NotNull
        private String goodsId;

        private Long originalPrice;
        /**
         * 商品数量
         */
        @NotNull
        private Integer qty;
        private String activityCode;
    }

}
