package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.GetMenuResponseDto;
import cn.freemud.entities.vo.*;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Arrays;
import java.util.Map;

import static org.junit.Assert.*;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title:
 * @Package: cn.freemud.service.thirdpart
 * @Description:
 * @author: biao.zhang
 * @date: 2018/12/17 16:34
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class ItemServiceTest {
    @Autowired
    private ItemService itemService;







    @Test
    public void hasAttributeAll() {
        GetMenuResponseDto.DataBean.RootNodeBean.ChildrenBeanFirst.ChildrenBeanSecond.ProductBean productBean = new GetMenuResponseDto.DataBean.RootNodeBean.ChildrenBeanFirst.ChildrenBeanSecond.ProductBean();
        boolean result = itemService.hasAttributeAll(Arrays.asList("1", "2"), productBean);
        assertTrue(result);
    }

    @Test
    public void getProducts() {
        Map<String, GetProductsVo> maps = itemService.getProducts(Arrays.asList("1", "2"), "1864", "1011","saas");
        assertFalse(maps == null || maps.isEmpty());
    }
}
