package cn.freemud.controller;

import cn.freemud.ShoppingCartApplication;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ResponseResult;
import com.alibaba.fastjson.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import java.util.ArrayList;
import java.util.List;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ShoppingCartControllerTest
 * @Package cn.freemud.controller
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/6/25 17:30
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = ShoppingCartApplication.class)
public class ShoppingCartControllerMallTest {
    @Autowired
    private WebApplicationContext wac;
    private MockMvc mockMvc;

    @Before
    public void setUp() {
        mockMvc = MockMvcBuilders.webAppContextSetup(wac).build();
    }

    /**
     * 添加商品
     */
    @Test
    public void addGoods() {

        String str = "{\"spuId\":\"154916516745371156\",\"skuId\":\"\",\"qty\":10,\"categoryId\":\"0101\",\"categoryName\":\"1分钱\"," +
                "\"productComboList\":[],\"productGroupList\":[],\"channelType\":\"saasmall\",\"partnerId\":\"1864\",\"appId\":\"wxb78fb7c6218cb52c\"," +
                "\"sessionId\":\"testMallUser\",\"orderType\":\"\",\"shopId\":\"0000622\"}";
        try {
            mockMvc.perform(post("/shoppingCart/addGoods").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 更新数量
     */
    @Test
    public void updateGoodsQty() {
        String requestJson = "{\"shopId\":\"0000622\",\"cartGoodsUid\":\"3c6c126b-ce1a-4489-930d-28940c4edb0a\",\"qty\":3,\"channelType\":\"saasmall\"," +
                "\"partnerId\":\"1864\",\"appId\":\"wxb78fb7c6218cb52c\",\"sessionId\":\"testMallUser\",\"orderType\":\"\"}";
        try {
            mockMvc.perform(post("/shoppingCart/updateGoodsQty").content(requestJson).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void listCartGoods() {
        String requestJson = "{\"shopId\":\"0000622\",\"useCustomerScore\":0,\"couponCode\":\"\",\"activityCode\":\"\",\"flag\":\"\",\"sendGoods\":[]," +
                "\"buyMemberCard\":null,\"channelType\":\"saasmall\",\"partnerId\":\"1864\",\"appId\":\"wxb78fb7c6218cb52c\",\"sessionId\":\"testMallUser\",\"orderType\":\"\"}";
        try {
            mockMvc.perform(post("/shoppingCart/listCartGoods").content(requestJson).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }



    /**
     * 清空购物车
     */
    @Test
    public void clearCartGoods() {
        String str = "{\"channelType\":\"saasmall\",\"partnerId\":\"1864\",\"appId\":\"wxb78fb7c6218cb52c\",\"sessionId\":\"testMallUser\",\"orderType\":\"\",\"shopId\":\"0000622\"}";
        try {
            mockMvc.perform(post("/shoppingCart/clearCartGoods").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
