/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/10 16:06
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.*;
import cn.freemud.entities.dto.coupon.CouponAvailableRespDto;
import cn.freemud.entities.vo.coupon.CouponAvailableReqVo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

// 测试http://115.159.65.101:8002  线上http://10.51.0.37:8002
//@FeignClient(name = "COUPON",url="${saas.couponclient.feign.url}")
@FeignClient(name = "COUPON-ADAPTER", url = "${saas.couponadapterclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CouponAdapterClient {

    /**
     * 获取可用券信息
     *
     * @param couponAvailableReqVo
     * @return
     */
    @PostMapping("/getCouponsAvailable")
    CouponAvailableRespDto getCouponsAvailable(CouponAvailableReqVo couponAvailableReqVo);

}
