package cn.freemud.service.impl.mcoffee.entity;

import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: SwitchShoppingCartRequestVo
 * @Package cn.freemud.service.impl.mcoffee.entity
 * @Description:
 * @author: ping1.wu
 * @date: 2020/8/10 17:12
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class SwitchShoppingCartRequestVo {

    @NotEmpty(message = "sessionId不能为空")
    private String sessionId;

    @NotEmpty(message = "appId不能为空")
    private String appId;

    /**
     * 商户Id
     */
    @NotEmpty(message = "partnerId不能为空")
    private String partnerId;

    /**
     * 门店Id
     */
    @NotEmpty(message = "fromShopId不能为空")
    private String fromShopId;

    @NotEmpty(message = "toShopId不能为空")
    private String toShopId;
    /**
     * 下单类型 CreateOrderType 外卖、到店、商城
     */
    private Integer orderType;

    /**
     * 渠道类型 OrderChannelType
     */
    private String channelType;

    /**
     * 优惠券code
     */
    private String couponCode;
    /**
     * 优惠券对应的活动号
     */
    private String activityCode;

    /**
     * 到店类型  orderType 传1的时候    如果reachStoreTyp为空转成订单类型4  如果不为空存储4(打包带走)和5（店内就餐）
     */
    private Integer reachStoreType;

    /**
     * 收货地址ID、svc卡支付外卖订单必传
     */
    private String receiveId;

    /**
     * 业务类型
     */
    private String menuType;

    /**
     * 操作类型 ShoppingCartOperationType　枚举
     */
    private Integer operationType;

}
