package cn.freemud.service.impl;

import cn.freemud.entities.dto.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.service.IPromotionService;
import lombok.Data;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;


import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: MemberDiscountServiceImpl
 * @Package cn.freemud.service.impl
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/5/29 14:52
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service("memberDiscountService")
public class MemberDiscountServiceImpl implements IPromotionService {
    @Override
    public void updateShoppingCartGoodsDiscount(CouponPromotionVO couponPromotionVO, ActivityQueryDto activityQueryDto, ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult, List<CartGoods> cartGoodsList, ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo, UserLoginInfoDto userLoginInfoDto, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {
        //获取每个商品的会员价优惠单价
        Map<String, Long> apportionGoodsDetail = getApportionGoodsDetail(calculationDiscountResult);
        if (apportionGoodsDetail==null||apportionGoodsDetail.size()==0){
            return;
        }

        for (CartGoods cartGoods : cartGoodsList) {
            //优惠单价
            Long discountPrice = apportionGoodsDetail.get(cartGoods.getGoodsId());
            if (discountPrice!=null && discountPrice>0){
                cartGoods.setAmount(cartGoods.getAmount()-discountPrice*cartGoods.getQty());
            }
        }
    }

    @Override
    public void updateShoppingCartGoodsApportion(ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo, ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult, ShoppingCartGoodsDto shoppingCartGoodsDto, CreateOrderVo.PremiumExchangeActivity premiumExchangeActivity, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {
        return;
    }

    /**
     * 单个商品，每个均摊单价
     * @param calculationDiscountResult
     * @return key:goodId  value:每个商品均摊金额
     */
    private Map<String,Long> getApportionGoodsDetail(ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult) {
        // 遍历购物车内的商品，如果存在则进行均摊
        if (calculationDiscountResult == null || CollectionUtils.isEmpty(calculationDiscountResult.getApportionGoods())) {
            return null;
        }
        Map<String,Long> result=new HashMap<>();
        for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods apportionGood : calculationDiscountResult.getApportionGoods()) {
            if (!CollectionUtils.isEmpty(apportionGood.getApportionDetails())) {
                for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.ApportionDetails apportionDetail : apportionGood.getApportionDetails()) {
                    if (apportionDetail.getActivityType().equals(ActivityTypeEnum.TYPE_320.getCode())) {
                       result.putIfAbsent(apportionGood.getGoodsId(),apportionDetail.getActivityApportionAmount());
                    }
                }
            }
        }
        return result;
    }

}
