package cn.freemud.entities.vo;

import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @author liming.guo
 * @date 2018/05/08
 */
@Data
public class UserLoginVo {

    /**
     * 用户会话session
     */
    private String sessionId;

    /**
     * 是否注册  1 注册 0 未注册
     */
    private Integer registered;

    /**
     * 是否有昵称 修改为 是否有图像 1 有昵称 0 无昵称
     */
    private int nickNamed;
    /**
     * 用户昵称
     */
    private String nickName;
    /**
     * 用户手机号
     */
    private String mobile;
    /**
     * 微信id
     */
    private String openId;

    /**
     * unionId
     */
    private String unionId;

    /**
     * 特约支付商户号
     */
    private String subMchId;
    
    private String memberId;
    /**
     * 插件map
     *
     * @return
     */
    private Map<String, Boolean> plugins;
    /**
     * 插件参数map
     */
    private Map<String, Object> pluginsParam;

    /**
     * 异常code对应图片集合
     */
    private List<ErrorImage> errorImages;

    @Data
    public static class ErrorImage {

        private String errorCode;

        private String errorMessage;

        private String imageUrl;
    }

}
