package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

@NoArgsConstructor
@Data
public class QueryReceiveAddressResponseDto {
    /**
     * code : 100
     * message :
     * result : {"account":"115282057807565892","createTime":"2018-07-02 09:47:18","distance":null,"id":"3215304960378195128","isDefault":2,"label":"4","latitude":"31.26711","longitude":"121.3773","partnerId":"360bb48b-5316-458a-903e-9a44c7f339b1","receiveAddress":"耀光中环国际","receiveMobile":"18802109227","receiveName":"griggles","sendMobile":"","sex":1,"updateTime":"2018-07-02 16:06:52","zipCode":""}
     * ver : 1
     */

    private String code;
    private String message;
    private ResultBean data;
    private String ver;

    @NoArgsConstructor
    @Data
    public static class ResultBean {
        /**
         * account : 115282057807565892
         * createTime : 2018-07-02 09:47:18
         * distance : null
         * id : 3215304960378195128
         * isDefault : 2
         * label : 4
         * latitude : 31.26711
         * longitude : 121.3773
         * partnerId : 360bb48b-5316-458a-903e-9a44c7f339b1
         * receiveAddress : 耀光中环国际
         * receiveMobile : 18802109227
         * receiveName : griggles
         * sendMobile :
         * sex : 1
         * updateTime : 2018-07-02 16:06:52
         * zipCode :
         */

        private String memberId;
        private String createTime;
        private String distance;
        private String id;
        private String isDefault;
        /**
         * 标签类型（1：公司 2：家 3：学校 4：其他）
         */
        private Integer labelType;
        /**
         * 标签名称
         */
        private String labelName;
        private String latitude;
        private String longitude;
        private String partnerId;
        private String receiveAddress;
        private String detailAddress = "none";
        private String receiveMobile;
        private String receiveName;
        private String sendMobile;
        private String mobile;
        private Integer sex;
        private String updateTime;
        private String zipCode;
    }
}
