/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetMemberCouponListRequestDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: song.cai
 * @date: 2018/12/24 16:49
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import java.util.List;

@Data
@RequiredArgsConstructor
public class GetMemberCouponListRequestDto {
    @NonNull
    private String partnerId;
    @NonNull
    private String memberId;
    /**
     * 券状态{-1所有 0可用(剔除过期) 1已使用 6已过期(根据生失效日期)}
     */
    private List<Integer> statusFlags;
    /**
     * 优惠券类型{ 0 商品券 1是代金券 3 折扣券}
     */
    private Integer couponType;
    /**
     * 是否需要活动商品券相关商品数据{1需要 0不需要(默认)}
     */
    private Integer isProduct = 0;
    /**
     * 页号 从 1 开始
     */
    private Integer pageNum;
    /**
     * 每页条目数
     */
    private Integer pageSize;


    //以下为麦咖啡需要参数
    private String appId;

    private String unionId;

    private String thirdPartyMemberId;

    private String tag;

}
